/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class NameTagMagic
extends Magic {
    private List<String> syllables;

    public NameTagMagic(MagicType<? extends NameTagMagic> type) {
        super(type);
    }

    public NameTagMagic setAdditionalParams(List<String> syllables) {
        this.syllables = syllables;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.syllables = MagicUtil.readColl(json, "syllables", e -> JSONUtils.func_151206_a((JsonElement)e, (String)"syllable"), new ArrayList());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "syllables", this.syllables, s -> new JsonPrimitive(s));
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildupMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    private String randomName(Random rand) {
        String name = "";
        for (int i = 0; i < rand.nextInt(3) + 2; ++i) {
            name = name + this.syllables.get(rand.nextInt(this.syllables.size()));
        }
        return StringUtils.capitalize((String)name);
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        player.func_184185_a(ModSounds.SCRIBBLE, 1.0f, this.soundPitch(player));
        if (!world.field_72995_K) {
            String name = this.randomName(player.func_70681_au());
            this.cost(player);
            WizardStaffItemHandler handler = WizardStaffItemHandler.get(staff);
            ItemStack nametag = handler.extractItem(0, 1, false);
            nametag = Items.field_151057_cb.func_190903_i();
            nametag.func_200302_a((ITextComponent)new StringTextComponent(name));
            handler.insertItem(0, nametag, false);
        }
        return super.magicFinish(world, player, staff);
    }
}

