/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.capability;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class Experience
implements INBTSerializable<DoubleNBT> {
    @CapabilityInject(value=Experience.class)
    public static final Capability<Experience> CAPABILITY = null;
    private double exp;

    public int add(double value) {
        this.exp += value;
        int whole = (int)this.exp;
        this.exp -= (double)whole;
        return whole;
    }

    public static int add(PlayerEntity player, double value) {
        return ((Experience)player.getCapability(CAPABILITY).orElse((Object)new Experience())).add(value);
    }

    public DoubleNBT serializeNBT() {
        return DoubleNBT.func_229684_a_((double)this.exp);
    }

    public void deserializeNBT(DoubleNBT nbt) {
        this.exp = nbt.func_150286_g();
    }

    public static class ExperienceStorage
    implements Capability.IStorage<Experience> {
        public INBT writeNBT(Capability<Experience> capability, Experience instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<Experience> capability, Experience instance, Direction side, INBT nbt) {
            instance.deserializeNBT((DoubleNBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="wizard-staff", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ExperienceProvider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<Experience> instance = LazyOptional.of(() -> CAPABILITY.getDefaultInstance());
        public static final ResourceLocation EXPERIENCE_LOCATION = new ResourceLocation("wizard-staff", "experience");

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public INBT serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
        }

        public void deserializeNBT(INBT nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, nbt);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(EXPERIENCE_LOCATION, (ICapabilityProvider)new ExperienceProvider());
            }
        }
    }
}

