/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.event;

import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.capability.Experience;
import mod.vemerion.wizardstaff.capability.ScreenAnimations;
import mod.vemerion.wizardstaff.capability.Wizard;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wizard-staff", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    @SubscribeEvent
    public static void addMagicsReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)Magics.getInstance(false));
    }

    @SubscribeEvent
    public static void synchMagics(PlayerEvent.PlayerLoggedInEvent event) {
        Magics.getInstance(false).sendAllMagicMessage((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void tickWizard(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        Wizard.getWizardOptional(player).ifPresent(w -> w.tick(player));
    }

    @SubscribeEvent
    public static void cloneCapabilities(PlayerEvent.Clone event) {
        PlayerEntity original = event.getOriginal();
        PlayerEntity player = event.getPlayer();
        ForgeEventSubscriber.copyCap(player, original, Experience.CAPABILITY);
        ForgeEventSubscriber.copyCap(player, original, ScreenAnimations.CAPABILITY);
        ForgeEventSubscriber.copyCap(player, original, Wizard.CAPABILITY);
    }

    private static <T extends INBT> void copyCap(PlayerEntity dest, PlayerEntity src, Capability<? extends INBTSerializable<T>> cap) {
        src.getCapability(cap).ifPresent(c1 -> dest.getCapability(cap).ifPresent(c2 -> c2.deserializeNBT(c1.serializeNBT())));
    }
}

