/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.init.ModMagics;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateMagicsMessage {
    private Map<ResourceLocation, Magic> magics;

    public UpdateMagicsMessage(Map<ResourceLocation, Magic> magics) {
        this.magics = magics;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.magics.size());
        for (Map.Entry<ResourceLocation, Magic> entry : this.magics.entrySet()) {
            Magic m = entry.getValue();
            buffer.func_192572_a(entry.getKey());
            buffer.func_192572_a(m.getRegistryName());
            m.encode(buffer);
        }
    }

    public static UpdateMagicsMessage decode(PacketBuffer buffer) {
        HashMap<ResourceLocation, Magic> magics = new HashMap<ResourceLocation, Magic>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.func_192575_l();
            ResourceLocation name = buffer.func_192575_l();
            Object magic = ((MagicType)ModMagics.REGISTRY.getValue(name)).create();
            ((Magic)magic).decode(buffer);
            magics.put(key, (Magic)magic);
        }
        return new UpdateMagicsMessage(magics);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> UpdateMagics.update(this.magics)));
    }

    private static class UpdateMagics {
        private UpdateMagics() {
        }

        private static DistExecutor.SafeRunnable update(final Map<ResourceLocation, Magic> magics) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    if (Magics.getInstance(true) != null) {
                        Magics.getInstance(true).addMagics(magics);
                    }
                }
            };
        }
    }
}

