/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="wizard-staff", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class HeldItemFilterLayer
extends HeldItemLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private static final Set<PlayerRenderer> injected = Collections.newSetFromMap(new WeakHashMap());
    private LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> parent;

    @SubscribeEvent
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        PlayerRenderer renderer = event.getRenderer();
        if (renderer != null && !injected.contains(renderer)) {
            HeldItemFilterLayer.addFilterLayer(renderer);
            renderer.func_177094_a((LayerRenderer)new WizardStaffLayer(renderer));
            injected.add(renderer);
        }
    }

    private static void addFilterLayer(PlayerRenderer renderer) {
        try {
            List layers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingRenderer.class, (Object)renderer, (String)"field_177097_h");
            if (layers != null) {
                LayerRenderer heldItemLayer = null;
                for (LayerRenderer layerRenderer : layers) {
                    if (!(layerRenderer instanceof HeldItemLayer) || layerRenderer instanceof HeldItemFilterLayer) continue;
                    heldItemLayer = layerRenderer;
                    break;
                }
                if (heldItemLayer != null) {
                    renderer.func_177094_a((LayerRenderer)new HeldItemFilterLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderer, heldItemLayer));
                    layers.remove(heldItemLayer);
                }
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            Main.LOGGER.warn("Unable to access RenderLivingBase.layerRenderers, reason: " + (Object)((Object)e));
        }
    }

    public HeldItemFilterLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer, LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> parent) {
        super(renderer);
        this.parent = parent;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack activeItem = entitylivingbaseIn.func_184607_cu();
        this.setStaffVisibility(activeItem, false);
        this.parent.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.setStaffVisibility(activeItem, true);
    }

    private void setStaffVisibility(ItemStack itemStack, boolean visible) {
        WizardStaffItemHandler.getOptional(itemStack).ifPresent(handler -> handler.setVisible(visible));
    }
}

