/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import javax.annotation.Nullable;
import mod.vemerion.wizardstaff.Magic.Magics;
import mod.vemerion.wizardstaff.capability.ScreenAnimations;
import mod.vemerion.wizardstaff.staff.WizardStaffCapabilityProvider;
import mod.vemerion.wizardstaff.staff.WizardStaffContainer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class WizardStaffItem
extends Item {
    public WizardStaffItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                boolean shouldAnimate = ScreenAnimations.getScreenAnimations(playerIn).shouldAnimate();
                SimpleNamedContainerProvider provider = new SimpleNamedContainerProvider((id, inventory, player) -> new WizardStaffContainer(id, inventory, WizardStaffItemHandler.get(itemstack), itemstack, shouldAnimate, handIn), this.func_200295_i(itemstack));
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)provider, buffer -> {
                    buffer.writeBoolean(handIn == Hand.MAIN_HAND);
                    buffer.writeBoolean(shouldAnimate);
                });
            }
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        ItemStack magic = WizardStaffItem.getMagic(itemstack);
        Magics.getInstance(worldIn).get(magic).magicStart(worldIn, playerIn, itemstack);
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public static WizardStaffItemHandler getHandler(ItemStack itemstack) {
        WizardStaffItemHandler handler = (WizardStaffItemHandler)((Object)itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("Wizard staff item is missing capability")));
        return handler;
    }

    public static ItemStack getMagic(ItemStack itemstack) {
        return WizardStaffItem.getHandler(itemstack).getStackInSlot(0);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack == newStack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new WizardStaffCapabilityProvider();
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (EffectiveSide.get().isClient()) {
            ItemStack magic = WizardStaffItem.getMagic(stack);
            return Magics.getInstance(true).get(magic).getUseAction(stack);
        }
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        return Magics.getInstance(EffectiveSide.get().isClient()).get(magic).getUseDuration(stack);
    }

    public void func_219972_a(World worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        if (livingEntityIn instanceof PlayerEntity) {
            Magics.getInstance(worldIn).get(magic).magicTick(worldIn, (PlayerEntity)livingEntityIn, stack, count);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        if (entityLiving instanceof PlayerEntity) {
            return Magics.getInstance(worldIn).get(magic).magicFinish(worldIn, (PlayerEntity)entityLiving, stack);
        }
        return stack;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack magic = WizardStaffItem.getMagic(context.func_195996_i());
        if (context.func_195999_j() == null) {
            return ActionResultType.PASS;
        }
        return Magics.getInstance(context.func_195991_k()).get(magic).magicInteractBlock(context);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        ItemStack magic = WizardStaffItem.getMagic(stack);
        if (entityLiving instanceof PlayerEntity) {
            Magics.getInstance(worldIn).get(magic).magicCancel(worldIn, (PlayerEntity)entityLiving, stack, timeLeft);
        }
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT result = new CompoundNBT();
        CompoundNBT tag = super.getShareTag(stack);
        CompoundNBT cap = WizardStaffItemHandler.get(stack).serializeNBT();
        if (tag != null) {
            result.func_218657_a("tag", (INBT)tag);
        }
        if (cap != null) {
            result.func_218657_a("cap", (INBT)cap);
        }
        return result;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null) {
            stack.func_77982_d(nbt);
        } else {
            stack.func_77982_d(nbt.func_74775_l("tag"));
            WizardStaffItemHandler.get(stack).deserializeNBT(nbt.func_74775_l("cap"));
        }
    }
}

