/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones.client;

import info.tehnut.xtones.Xtones;
import info.tehnut.xtones.block.XtoneBlock;
import info.tehnut.xtones.config.XtonesConfig;
import info.tehnut.xtones.item.XtoneBlockItem;
import info.tehnut.xtones.network.XtonesNetwork;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.checkerframework.checker.nullness.qual.Nullable;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="xtones")
public final class XtonesClient {
    private static final KeyBinding SCROLL_MODIFIER = new KeyBinding("key.xtones.scroll", (IKeyConflictContext)KeyConflictContext.IN_GAME, 42, "Xtones");
    private static boolean serverXtoneCycling;

    private XtonesClient() {
    }

    public static String getScrollModifierName() {
        return SCROLL_MODIFIER.getDisplayName();
    }

    public static boolean canCycleXtones() {
        return XtonesConfig.hasXtoneCycling() && serverXtoneCycling;
    }

    public static void setServerXtoneCycling(boolean state) {
        serverXtoneCycling = state;
    }

    @SubscribeEvent
    static void registerModels(ModelRegistryEvent event) {
        Xtones.items().forEach(item -> {
            for (XtoneBlock.Variant variant : XtoneBlock.Variant.values()) {
                XtonesClient.setCustomModelResourceLocation(item, variant.ordinal(), "variant=" + (Object)((Object)variant));
            }
        });
        XtonesClient.setCustomModelResourceLocation(Xtones.baseItem(), 0, "normal");
        XtonesClient.setCustomModelResourceLocation(Xtones.lampItem(), 0, "active=false,facing=up");
    }

    @SubscribeEvent
    static void mousePolled(MouseEvent event) {
        int scroll = event.getDwheel();
        if (scroll != 0 && XtonesClient.canCycleXtones() && SCROLL_MODIFIER.func_151470_d()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            @Nullable EntityPlayerSP player = minecraft.field_71439_g;
            if (player != null && minecraft.field_71462_r == null) {
                EnumHand hand = EnumHand.MAIN_HAND;
                if (!XtonesClient.isXtone(player.func_184586_b(hand))) {
                    hand = EnumHand.OFF_HAND;
                }
                if (XtonesClient.isXtone(player.func_184586_b(hand))) {
                    XtonesNetwork.cycleXtone((EntityPlayer)player, hand, scroll);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static void setCustomModelResourceLocation(Item item, int meta, String variant) {
        ResourceLocation name = Objects.requireNonNull(item.getRegistryName());
        ModelResourceLocation model = new ModelResourceLocation(name, variant);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)model);
    }

    private static boolean isXtone(ItemStack stack) {
        return stack.func_77973_b() instanceof XtoneBlockItem;
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)SCROLL_MODIFIER);
        serverXtoneCycling = false;
    }
}

