/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones.network;

import com.mojang.authlib.GameProfile;
import info.tehnut.xtones.config.XtonesConfig;
import info.tehnut.xtones.item.XtoneBlockItem;
import info.tehnut.xtones.network.XtoneCycleMessage;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

final class XtoneCycleHandler
implements IMessageHandler<XtoneCycleMessage, IMessage> {
    static final XtoneCycleHandler INSTANCE = new XtoneCycleHandler();
    private static final Logger LOGGER = LogManager.getLogger();

    private XtoneCycleHandler() {
    }

    private static void tryCycle(EntityPlayer player, XtoneCycleMessage cycle) {
        if (XtonesConfig.disableScrollCycling) {
            GameProfile profile = player.func_146103_bH();
            LOGGER.warn("{} ({}) tried to cycle when cycling is disabled", (Object)profile.getName(), (Object)profile.getId());
            return;
        }
        if ((cycle.getHand() == EnumHand.OFF_HAND ? -1 : player.field_71071_by.field_70461_c) == cycle.getExpectedSlot()) {
            ItemStack held = player.func_184586_b(cycle.getHand());
            if (!(held.func_77973_b() instanceof XtoneBlockItem)) {
                GameProfile profile = player.func_146103_bH();
                String item = Objects.toString(held.func_77973_b().getRegistryName(), "an unregistered item");
                LOGGER.warn("{} ({}) tried to cycle {}", (Object)profile.getName(), (Object)profile.getId(), (Object)item);
                return;
            }
            held.func_77964_b(held.func_77952_i() + cycle.getOffset() & 0xF);
        }
    }

    public @Nullable IMessage onMessage(XtoneCycleMessage cycle, MessageContext context) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> XtoneCycleHandler.tryCycle((EntityPlayer)context.getServerHandler().field_147369_b, cycle));
        return null;
    }
}

