/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.events;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import zettasword.zettaimagic.system.ConfigHandler;
import zettasword.zettaimagic.system.compat.AstralSorceryRecipes;
import zettasword.zettaimagic.system.registers.KeybindsRegister;
import zettasword.zettaimagic.util.magic_lib.Mage;

@Mod.EventBusSubscriber
public class EventsHandler {
    @SubscribeEvent
    public static void OnCastCircles(SpellCastEvent.Post event) {
        if (Loader.isModLoaded((String)"arte_magicum")) {
            return;
        }
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer caster = (EntityPlayer)event.getCaster();
            Mage.CircleCreate(event.getSpell().getElement(), event.getWorld(), (EntityLivingBase)caster);
        } else if (event.getCaster() != null && ConfigHandler.ZettaiMagicConfig.casting_creatures) {
            Mage.CircleCreate(event.getSpell().getElement(), event.getWorld(), event.getCaster());
        }
    }

    @SubscribeEvent
    public static void OnSummon(EntityJoinWorldEvent event) {
        if ((event.getEntity() instanceof ISummonedCreature || event.getEntity() instanceof EntitySummonedCreature || event.getEntity() instanceof EntitySpiritWolf || event.getEntity() instanceof EntitySpiritHorse) && ConfigHandler.ZettaiMagicConfig.summoning && !Loader.isModLoaded((String)"arte_magicum") && !event.getEntity().getEntityData().func_74764_b("spawned")) {
            event.getEntity().getEntityData().func_74757_a("spawned", true);
            Mage.Summon(event.getWorld(), event.getEntity());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void OwningCastingShowMP(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && ConfigHandler.ZettaiMagicConfig.owning_cast) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            ItemStack stack = player.func_184607_cu();
            if (stack.func_77973_b() instanceof IManaStoringItem && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("owner")) {
                IManaStoringItem item = (IManaStoringItem)stack.func_77973_b();
                mc.field_71466_p.func_175063_a(item.getMana(stack) + " / " + item.getManaCapacity(stack) + TextFormatting.AQUA + " MP", (float)ConfigHandler.ZettaiMagicConfig.owningMechanic.x, (float)ConfigHandler.ZettaiMagicConfig.owningMechanic.y, 0xFFFFFF);
            }
        }
    }

    public static void OnOwningCast(SpellCastEvent.Post event) {
        if (event.getCaster() instanceof EntityPlayer && ConfigHandler.ZettaiMagicConfig.owning_cast) {
            ItemStack stack = event.getCaster().func_184607_cu();
            EntityPlayer pl = (EntityPlayer)event.getCaster();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("owner") && stack.func_77973_b() instanceof IManaStoringItem) {
                IManaStoringItem manai = (IManaStoringItem)stack.func_77973_b();
                if (!event.getWorld().field_72995_K) {
                    pl.func_146105_b((ITextComponent)new TextComponentString(stack.func_82833_r() + ": " + I18n.func_135052_a((String)"spell.magic_bind.cast", (Object[])new Object[0]) + " " + TextFormatting.AQUA + manai.getMana(stack)), true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public static void OnItemTooltip(ItemTooltipEvent event) {
        Spell spell;
        boolean discovered;
        ItemStack item = event.getItemStack();
        if (item.func_77978_p() != null && item.func_77978_p().func_74764_b("owner")) {
            String key;
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"spell.magic_bind.owner", (Object[])new Object[0]) + " " + item.func_77978_p().func_74779_i("owner"));
            if (item.func_77973_b() instanceof IManaStoringItem) {
                if (Keyboard.isKeyDown((int)KeybindsRegister.SHOW_MANA.func_151463_i())) {
                    IManaStoringItem manaitem = (IManaStoringItem)item.func_77973_b();
                    event.getToolTip().add("Mana: " + TextFormatting.AQUA + manaitem.getMana(item));
                } else {
                    key = Keyboard.getKeyName((int)KeybindsRegister.SHOW_MANA.func_151463_i());
                    event.getToolTip().add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + key + " to see Mana Points");
                }
            } else if (item.func_77973_b().func_77645_m()) {
                if (Keyboard.isKeyDown((int)KeybindsRegister.SHOW_MANA.func_151463_i())) {
                    event.getToolTip().add("Durability: " + (item.func_77973_b().getMaxDamage(item) - item.func_77973_b().getDamage(item)));
                } else {
                    key = Keyboard.getKeyName((int)KeybindsRegister.SHOW_MANA.func_151463_i());
                    event.getToolTip().add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + key + " to see Durability");
                }
            }
        }
        if (item.func_77973_b() instanceof ItemSpellBook && Keyboard.isKeyDown((int)KeybindsRegister.SHOW_MANA.func_151463_i()) && (discovered = Wizardry.proxy.shouldDisplayDiscovered(spell = Spell.byMetadata((int)item.func_77952_i()), item))) {
            event.getToolTip().add("Element: " + spell.getElement().getColour().func_150215_a() + spell.getElement().getDisplayName());
        }
    }

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("zettaimagic")) {
            ConfigManager.sync((String)"zettaimagic", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerRecipe(RegistryEvent.Register<IRecipe> event) {
        if (Loader.isModLoaded((String)"astralsorcery")) {
            AstralSorceryRecipes.init();
        }
    }
}

