/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.items;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zettasword.zettaimagic.system.ZettaiTabs;
import zettasword.zettaimagic.util.MagicItems;
import zettasword.zettaimagic.util.ParticlePrefab;

public class MagicGlove
extends ItemWand {
    public static final int BASE_SPELL_SLOTS = 5;
    private static final int CONTINUOUS_TRACKING_INTERVAL = 20;
    private static final float ELEMENTAL_PROGRESSION_MODIFIER = 0.6f;
    private static final float DISCOVERY_PROGRESSION_MODIFIER = 2.0f;
    private static final float SECOND_TIME_PROGRESSION_MODIFIER = 1.5f;
    private static final float MAX_PROGRESSION_REDUCTION = 0.9f;

    public MagicGlove(Tier tier, Element element, String RegistryName) {
        super(tier, element);
        this.setRegistryName(RegistryName);
        this.func_77655_b(RegistryName);
        this.func_77625_d(1);
        this.func_77637_a(ZettaiTabs.MagicMaterials);
        this.tier = tier;
        this.element = element;
        this.func_77656_e(this.tier.maxCharge);
        WizardryRecipes.addToManaFlaskCharging((Item)this);
        this.func_185043_a(new ResourceLocation("pointing"), (s, w, e) -> e != null && e.func_184607_cu() == s && (s.func_77975_n() == SpellActions.POINT || s.func_77975_n() == SpellActions.POINT_UP || s.func_77975_n() == SpellActions.POINT_DOWN || s.func_77975_n() == SpellActions.GRAPPLE || s.func_77975_n() == SpellActions.SUMMON) ? 1.0f : 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> text, ITooltipFlag advanced) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.element != null) {
            if (this.element != Element.MAGIC) {
                text.add(Wizardry.proxy.translate("item.ebwizardry:wand.buff", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)((float)(this.tier.level + 1) * 0.1f * 100.0f + 0.5f), this.element.getDisplayName()}));
            } else {
                text.add(Wizardry.proxy.translate("element.magic.potency", new Style().func_150238_a(TextFormatting.LIGHT_PURPLE), new Object[]{(int)((float)(this.tier.level + 1) * 0.1f * 100.0f + 0.5f), this.element.getDisplayName()}));
            }
        }
        Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
        boolean discovered = true;
        if (Wizardry.settings.discoveryMode && !player.func_184812_l_() && WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
            discovered = false;
        }
        text.add(Wizardry.proxy.translate("item.ebwizardry:wand.spell", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{discovered ? spell.getDisplayNameWithFormatting() : "#" + TextFormatting.BLUE + SpellGlyphData.getGlyphName((Spell)spell, (World)player.field_70170_p)}));
        if (advanced.func_194127_a()) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.progression", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{WandHelper.getProgression((ItemStack)stack), this.tier.level < Tier.MASTER.level ? this.tier.next().getProgression() : 0}));
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        this.setMana(stack, 0);
    }

    public ItemStack applyUpgrade(@Nullable EntityPlayer player, ItemStack wand, ItemStack upgrade) {
        if (upgrade.func_77973_b() == WizardryItems.arcane_tome) {
            Tier tier = Tier.values()[upgrade.func_77952_i()];
            if ((player == null || player.func_184812_l_() || Wizardry.settings.legacyWandLevelling || WandHelper.getProgression((ItemStack)wand) >= tier.getProgression()) && tier == this.tier.next() && this.tier != Tier.MASTER) {
                if (Wizardry.settings.legacyWandLevelling) {
                    WandHelper.setProgression((ItemStack)wand, (int)0);
                } else {
                    WandHelper.setProgression((ItemStack)wand, (int)(WandHelper.getProgression((ItemStack)wand) - tier.getProgression()));
                }
                if (player != null) {
                    WizardData.get((EntityPlayer)player).setTierReached(tier);
                }
                ItemStack newWand = new ItemStack(MagicItems.getGlove(tier, this.element));
                newWand.func_77982_d(wand.func_77978_p());
                ((IManaStoringItem)newWand.func_77973_b()).setMana(newWand, this.getMana(wand));
                upgrade.func_190918_g(1);
                return newWand;
            }
        } else if (WandHelper.isWandUpgrade((Item)upgrade.func_77973_b())) {
            Item specialUpgrade = upgrade.func_77973_b();
            int maxUpgrades = this.tier.upgradeLimit;
            if (this.element == Element.MAGIC) {
                maxUpgrades += 3;
            }
            if (WandHelper.getTotalUpgrades((ItemStack)wand) < maxUpgrades && WandHelper.getUpgradeLevel((ItemStack)wand, (Item)specialUpgrade) < 3) {
                int prevMana = this.getMana(wand);
                WandHelper.applyUpgrade((ItemStack)wand, (Item)specialUpgrade);
                if (specialUpgrade == WizardryItems.storage_upgrade) {
                    this.setMana(wand, prevMana);
                } else if (specialUpgrade == WizardryItems.attunement_upgrade) {
                    int newSlotCount = 5 + WandHelper.getUpgradeLevel((ItemStack)wand, (Item)WizardryItems.attunement_upgrade);
                    Spell[] spells = WandHelper.getSpells((ItemStack)wand);
                    Spell[] newSpells = new Spell[newSlotCount];
                    for (int i = 0; i < newSpells.length; ++i) {
                        newSpells[i] = i < spells.length && spells[i] != null ? spells[i] : Spells.none;
                    }
                    WandHelper.setSpells((ItemStack)wand, (Spell[])newSpells);
                    int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                    int[] newCooldowns = new int[newSlotCount];
                    if (cooldowns.length > 0) {
                        System.arraycopy(cooldowns, 0, newCooldowns, 0, cooldowns.length);
                    }
                    WandHelper.setCooldowns((ItemStack)wand, (int[])newCooldowns);
                }
                upgrade.func_190918_g(1);
                if (player != null) {
                    WizardryAdvancementTriggers.special_upgrade.triggerFor(player);
                    if (WandHelper.getTotalUpgrades((ItemStack)wand) == Tier.MASTER.upgradeLimit) {
                        WizardryAdvancementTriggers.max_out_wand.triggerFor(player);
                    }
                }
            }
        }
        return wand;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
            SpellModifiers modifiers = WizardData.get((EntityPlayer)player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : this.calculateModifiers(stack, (EntityPlayer)user, spell);
            int useTick = stack.func_77988_m() - count;
            int chargeup = (int)((float)spell.getChargeup() * modifiers.get("chargeup"));
            boolean casted = false;
            if (spell.isContinuous) {
                if (useTick >= chargeup) {
                    int castingTick = useTick - chargeup;
                    if (castingTick == 0 || this.canCast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers)) {
                        this.cast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers);
                        casted = true;
                    } else {
                        player.func_184597_cx();
                    }
                }
            } else if (chargeup > 0 && useTick == chargeup) {
                this.cast(stack, spell, player, player.func_184600_cs(), 0, modifiers);
                casted = true;
            }
            if (player.field_70170_p.field_72995_K && !casted && useTick < chargeup) {
                ParticlePrefab.ManaCall(player, stack);
            }
        }
    }

    public SpellModifiers calculateModifiers(ItemStack stack, EntityPlayer player, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.range_upgrade);
        if (level > 0) {
            modifiers.set(WizardryItems.range_upgrade, 1.0f + (float)level * 0.25f, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.duration_upgrade)) > 0) {
            modifiers.set(WizardryItems.duration_upgrade, 1.0f + (float)level * 0.25f, false);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.blast_upgrade)) > 0) {
            modifiers.set(WizardryItems.blast_upgrade, 1.0f + (float)level * 0.25f, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.cooldown_upgrade)) > 0) {
            modifiers.set(WizardryItems.cooldown_upgrade, 1.0f - (float)level * 0.15f, true);
        }
        float progressionModifier = 1.0f - (float)WizardData.get((EntityPlayer)player).countRecentCasts(spell) / 5.0f * 0.9f;
        modifiers.set("potency", 1.0f + (float)(this.tier.level + 1) * 0.1f, true);
        progressionModifier *= 0.6f;
        if (WizardData.get((EntityPlayer)player) != null) {
            if (!WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
                progressionModifier *= 2.0f;
            }
            if (!WizardData.get((EntityPlayer)player).hasReachedTier(this.tier.next())) {
                progressionModifier *= 1.5f;
            }
        }
        modifiers.set("progression", progressionModifier, false);
        return modifiers;
    }
}

