/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.particles;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleBaseToff
extends Particle {
    private static final double GRAVITY = 0.04;
    private static final double GROUND_DECCEL = 0.7;
    private static final VertexFormat VERTEX_FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181714_n).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
    private TextureDefinition TEXTURE_DEF;
    private int currentAnimationFrame = 0;
    private float progress = 0.0f;
    private float rotSpeed = 0.0f;
    private double deccel = 0.98;
    private float initialAlpha = 1.0f;
    private float finalAlpha = 1.0f;
    private Color initialTint = Color.WHITE;
    private Color finalTint = Color.WHITE;
    private float initialScale = 1.0f;
    private float finalScale = 1.0f;
    private boolean enableDepth = true;
    protected boolean shaded = false;

    public ParticleBaseToff(TextureDefinition parTexDef, World parWorld, double parX, double parY, double parZ) {
        super(parWorld, parX, parY, parZ);
        this.TEXTURE_DEF = parTexDef;
        this.setShaded(false);
    }

    public void setShaded(boolean shaded) {
        this.shaded = shaded;
    }

    public int func_189214_a(float partialTick) {
        return this.shaded ? super.func_189214_a(partialTick) : 0xF000F0;
    }

    public ParticleBaseToff(TextureDefinition parTexDef, World parWorld, double parX, double parY, double parZ, double parMotionX, double parMotionY, double parMotionZ) {
        super(parWorld, parX, parY, parZ);
        this.TEXTURE_DEF = parTexDef;
        this.field_187129_i = parMotionX;
        this.field_187130_j = parMotionY;
        this.field_187131_k = parMotionZ;
    }

    public void func_189213_a() {
        this.updateTick();
        this.processGravityAndDeccel();
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.processAlphaTween();
        this.processTintTween();
        this.processScaleTween();
    }

    private void updateTick() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.progress = (float)this.field_70546_d / (float)this.field_70547_e;
        if (this.TEXTURE_DEF.isTweenAnimationMode()) {
            this.currentAnimationFrame = (int)(this.progress * (float)(this.TEXTURE_DEF.getAnimationFrameCount() + 1));
        } else if (this.currentAnimationFrame++ >= this.TEXTURE_DEF.getAnimationFrameCount()) {
            this.currentAnimationFrame = 0;
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F += (float)Math.PI * this.rotSpeed * 2.0f;
    }

    private void processGravityAndDeccel() {
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        this.field_187129_i *= this.deccel;
        this.field_187130_j *= this.deccel;
        this.field_187131_k *= this.deccel;
        this.rotSpeed = (float)((double)this.rotSpeed * this.deccel);
        if (this.field_187132_l && this.field_190017_n) {
            this.field_187129_i *= 0.7 * this.deccel;
            this.field_187131_k *= 0.7 * this.deccel;
        }
    }

    protected void processAlphaTween() {
        this.field_82339_as = this.initialAlpha + this.progress * (this.finalAlpha - this.initialAlpha);
    }

    protected void processTintTween() {
        this.field_70552_h = ((float)this.initialTint.getRed() + this.progress * (float)(this.finalTint.getRed() - this.initialTint.getRed())) / 256.0f;
        this.field_70551_j = ((float)this.initialTint.getBlue() + this.progress * (float)(this.finalTint.getBlue() - this.initialTint.getBlue())) / 256.0f;
        this.field_70553_i = ((float)this.initialTint.getGreen() + this.progress * (float)(this.finalTint.getGreen() - this.initialTint.getGreen())) / 256.0f;
    }

    protected void processScaleTween() {
        this.field_70544_f = this.initialScale + this.progress * (this.finalScale - this.initialScale);
    }

    public int func_70537_b() {
        return 3;
    }

    public boolean func_187111_c() {
        return !this.enableDepth;
    }

    public void func_180434_a(BufferBuilder bufferIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179092_a((int)516, (float)0.05f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_82339_as);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.TEXTURE_DEF.getResourceLocation());
        float uMin = this.TEXTURE_DEF.getUMin();
        float uMax = this.TEXTURE_DEF.getUMax();
        float frameV = (float)this.currentAnimationFrame * (this.TEXTURE_DEF.getVMax() - this.TEXTURE_DEF.getVmin());
        float vMin = this.TEXTURE_DEF.getVmin() + frameV;
        float vMax = this.TEXTURE_DEF.getVMax() + frameV;
        float scale = 0.1f * this.field_70544_f;
        float xInterp = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float yInterp = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float zInterp = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
        if (this.field_190014_F != 0.0f) {
            float angleInterp = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(angleInterp * 0.5f));
            float xComponent = MathHelper.func_76126_a((float)(angleInterp * 0.5f)) * (float)ParticleBaseToff.field_190016_K.field_72450_a;
            float yComponent = MathHelper.func_76126_a((float)(angleInterp * 0.5f)) * (float)ParticleBaseToff.field_190016_K.field_72448_b;
            float zComponent = MathHelper.func_76126_a((float)(angleInterp * 0.5f)) * (float)ParticleBaseToff.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)xComponent, (double)yComponent, (double)zComponent);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        int brightness = this.func_189214_a(partialTicks);
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        bufferIn.func_181668_a(7, VERTEX_FORMAT);
        bufferIn.func_181662_b((double)xInterp + avec3d[0].field_72450_a, (double)yInterp + avec3d[0].field_72448_b, (double)zInterp + avec3d[0].field_72449_c).func_187315_a((double)uMax, (double)vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferIn.func_181662_b((double)xInterp + avec3d[1].field_72450_a, (double)yInterp + avec3d[1].field_72448_b, (double)zInterp + avec3d[1].field_72449_c).func_187315_a((double)uMax, (double)vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferIn.func_181662_b((double)xInterp + avec3d[2].field_72450_a, (double)yInterp + avec3d[2].field_72448_b, (double)zInterp + avec3d[2].field_72449_c).func_187315_a((double)uMin, (double)vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferIn.func_181662_b((double)xInterp + avec3d[3].field_72450_a, (double)yInterp + avec3d[3].field_72448_b, (double)zInterp + avec3d[3].field_72449_c).func_187315_a((double)uMin, (double)vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    public ParticleBaseToff setLifeSpan(int lifeIn) {
        this.field_70547_e = lifeIn;
        return this;
    }

    public ParticleBaseToff setCanCollide(boolean canCollideIn) {
        this.field_190017_n = canCollideIn;
        return this;
    }

    public ParticleBaseToff setAABB(AxisAlignedBB boundingBoxIn) {
        this.func_187108_a(boundingBoxIn);
        return this;
    }

    public ParticleBaseToff setDeccel(double deccelIn) {
        this.deccel = deccelIn;
        return this;
    }

    public ParticleBaseToff setScale(float scaleIn) {
        this.field_70544_f = scaleIn;
        this.initialScale = scaleIn;
        this.finalScale = scaleIn;
        return this;
    }

    public ParticleBaseToff setTintColor(float redIn, float greenIn, float blueIn) {
        this.field_70552_h = redIn;
        this.field_70553_i = greenIn;
        this.field_70551_j = blueIn;
        this.finalTint = this.initialTint = new Color(redIn / 256.0f, greenIn / 256.0f, blueIn / 256.0f);
        return this;
    }

    public ParticleBaseToff setTintColor(Color colorIn) {
        this.field_70553_i = (float)colorIn.getGreen() / 256.0f;
        this.field_70551_j = (float)colorIn.getBlue() / 256.0f;
        this.field_70552_h = (float)colorIn.getRed() / 256.0f;
        this.finalTint = this.initialTint = colorIn;
        return this;
    }

    public ParticleBaseToff setTintColorAndAlpha(float redIn, float greenIn, float blueIn, float alphaIn) {
        this.setTintColor(redIn, greenIn, blueIn);
        this.setAlpha(alphaIn);
        return this;
    }

    public ParticleBaseToff setTintColorAndAlpha(Color colorIn) {
        this.setTintColor(colorIn);
        this.setAlpha(colorIn);
        return this;
    }

    public ParticleBaseToff setAlpha(float alphaIn) {
        this.field_82339_as = alphaIn;
        this.finalAlpha = this.initialAlpha = alphaIn;
        return this;
    }

    public ParticleBaseToff setAlpha(Color colorIn) {
        this.finalAlpha = this.initialAlpha = (this.field_82339_as = (float)colorIn.getAlpha() / 256.0f);
        return this;
    }

    public ParticleBaseToff setInitalTint(Color colorIn) {
        this.initialTint = colorIn;
        this.field_70553_i = (float)colorIn.getGreen() / 256.0f;
        this.field_70551_j = (float)colorIn.getBlue() / 256.0f;
        this.field_70552_h = (float)colorIn.getRed() / 256.0f;
        return this;
    }

    public ParticleBaseToff setFinalTint(Color colorIn) {
        this.finalTint = colorIn;
        return this;
    }

    public ParticleBaseToff setInitialAlpha(float alphaIn) {
        this.initialAlpha = alphaIn;
        this.field_82339_as = alphaIn;
        return this;
    }

    public ParticleBaseToff setInitialAlpha(Color colorIn) {
        this.initialAlpha = (float)colorIn.getAlpha() / 256.0f;
        this.field_82339_as = (float)colorIn.getAlpha() / 256.0f;
        return this;
    }

    public ParticleBaseToff setFinalAlpha(float alphaIn) {
        this.finalAlpha = alphaIn;
        return this;
    }

    public ParticleBaseToff setFinalAlpha(Color colorIn) {
        this.finalAlpha = (float)colorIn.getAlpha() / 256.0f;
        return this;
    }

    public ParticleBaseToff setInitialScale(float scaleIn) {
        this.field_70544_f = scaleIn;
        this.initialScale = scaleIn;
        return this;
    }

    public ParticleBaseToff setFinalScale(float scaleIn) {
        this.finalScale = scaleIn;
        return this;
    }

    public ParticleBaseToff setGravity(float gravityIn) {
        this.field_70545_g = gravityIn;
        return this;
    }

    public ParticleBaseToff setRotSpeed(float rotIn) {
        this.rotSpeed = rotIn;
        return this;
    }

    public ParticleBaseToff setEnableDepth(boolean enableDepthIn) {
        this.enableDepth = enableDepthIn;
        return this;
    }

    public static class TextureDefinition {
        private String name;
        private ResourceLocation resourceLocation;
        private float uMin;
        private float vMin;
        private float uMax;
        private float vMax;
        private boolean tweenAnimationMode;
        private int animationFrameCount;

        public TextureDefinition(String parName) {
            this(parName, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        private TextureDefinition(String parName, float parUMin, float parVMin, float parUMax, float parVMax) {
            this(parName, parUMin, parVMin, parUMax, parVMax, false, 1);
        }

        public TextureDefinition(String parName, boolean parAnimMode, int parAnimFrames) {
            this(parName, 0.0f, 0.0f, 1.0f, 1.0f / (float)parAnimFrames, parAnimMode, parAnimFrames);
        }

        private TextureDefinition(String parName, float parUMin, float parVMin, float parUMax, float parVMax, boolean parAnimMode, int parAnimFrames) {
            this.name = parName;
            this.resourceLocation = new ResourceLocation("zettaimagic", "textures/particles/" + this.name + ".png");
            this.uMin = parUMin;
            this.vMin = parVMin;
            this.uMax = parUMax;
            this.vMax = parVMax;
            this.tweenAnimationMode = parAnimMode;
            this.animationFrameCount = parAnimFrames;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public float getUMin() {
            return this.uMin;
        }

        public float getVmin() {
            return this.vMin;
        }

        public float getUMax() {
            return this.uMax;
        }

        public float getVMax() {
            return this.vMax;
        }

        public boolean isTweenAnimationMode() {
            return this.tweenAnimationMode;
        }

        public int getAnimationFrameCount() {
            return this.animationFrameCount;
        }
    }
}

