/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.spells.attack;

import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.spell.SpellArrow;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import zettasword.zettaimagic.entity.projectile.ExplosionCataclysmMissile;
import zettasword.zettaimagic.system.ZItems;
import zettasword.zettaimagic.system.registers.Sounds;
import zettasword.zettaimagic.util.MagicColor;
import zettasword.zettaimagic.util.ParticlePrefab;

public class ExplosionCataclysm
extends SpellArrow<ExplosionCataclysmMissile> {
    private static final String EXPLOSION_POWER = "explosion_power";

    public ExplosionCataclysm(String modID, String name, Function<World, ExplosionCataclysmMissile> arrowFactory) {
        super(modID, name, arrowFactory);
        this.addProperties(new String[]{EXPLOSION_POWER, "damage", "range"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            ExplosionCataclysmMissile projectile = (ExplosionCataclysmMissile)((Object)this.arrowFactory.apply(world));
            projectile.aim((EntityLivingBase)caster, this.calculateVelocity((EntityMagicArrow)projectile, modifiers, caster.func_70047_e() - 0.1f));
            projectile.damageMultiplier = modifiers.get("potency");
            projectile.explosionPower = this.getProperty(EXPLOSION_POWER).floatValue();
            projectile.damage = this.getProperty("damage").doubleValue();
            projectile.range = this.getProperty("range").intValue();
            this.addArrowExtras((EntityMagicArrow)projectile, (EntityLivingBase)caster, modifiers);
            world.func_72838_d((Entity)projectile);
        }
        if (world.field_72995_K) {
            float randomSize;
            Random r;
            int randLife;
            double z;
            double y;
            double x;
            int i;
            for (i = 0; i < 20; ++i) {
                x = caster.field_70165_t + world.field_73012_v.nextDouble() * 3.0 - 1.0;
                y = caster.field_70163_u + 0.7 + world.field_73012_v.nextDouble();
                z = caster.field_70161_v + world.field_73012_v.nextDouble() * 3.0 - 1.0;
                randLife = ThreadLocalRandom.current().nextInt(50, 101);
                r = new Random();
                randomSize = 1.0f + r.nextFloat() * 0.5f;
                ParticlePrefab.CustomSuperExtended(world, "gener_spark_2", x, y, z, ((float)Math.random() - 0.5f) * 0.15f, ((float)Math.random() - 0.5f) * 0.15f, ((float)Math.random() - 0.5f) * 0.15f, randLife, 0.0f, randomSize, 0.0f, 1.0f, 0.0f, (float)Math.random() - 0.5f, MagicColor.Arcane(), MagicColor.Arcane());
            }
            for (i = 0; i < 10; ++i) {
                x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                y = caster.field_70163_u + 0.7 + world.field_73012_v.nextDouble();
                z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                randLife = ThreadLocalRandom.current().nextInt(30, 81);
                r = new Random();
                randomSize = 1.5f + r.nextFloat() * 0.5f;
                ParticlePrefab.CustomSuperExtended(world, "gener_spark_3", x, y, z, ((float)Math.random() - 0.5f) * 0.15f, ((float)Math.random() - 0.5f) * 0.15f, ((float)Math.random() - 0.5f) * 0.15f, randLife, 0.0f, randomSize, 0.0f, 1.0f, 0.0f, ((float)Math.random() - 0.5f) * 1.4f, MagicColor.Arcane(), MagicColor.Arcane());
            }
            double x2 = caster.field_70165_t;
            double y2 = caster.field_70163_u;
            double z2 = caster.field_70161_v;
            ParticlePrefab.MagicStatic(world, "magic_explosion_empty", x2, y2, z2, 0.0f, 0.0f, 0.0f, 50, 0.0f, 10.0f, 1.0f, 0.0f, ((float)Math.random() - 0.5f) * 5.0f, MagicColor.Explosion, MagicColor.Explosion, false);
            ParticlePrefab.MagicStatic(world, "magic_explosion", x2, y2 + 2.5, z2, 0.0f, 0.0f, 0.0f, 50, 0.0f, 10.0f, 1.0f, 0.0f, ((float)Math.random() - 0.5f) * 5.0f, MagicColor.Explosion, MagicColor.Explosion, false);
            ParticlePrefab.MagicStatic(world, "magic_explosion_empty", x2, y2, z2, 0.0f, 0.0f, 0.0f, 70, 0.0f, 4.0f, 1.0f, 0.0f, ((float)Math.random() - 0.5f) * 5.0f, MagicColor.Explosion, MagicColor.Explosion, false);
        }
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, Sounds.Spellcast2, SoundCategory.PLAYERS, 1.0f, 2.0f, false);
        return true;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return super.canBeCastBy(npc, override);
    }

    public boolean applicableForItem(Item item) {
        return item == ZItems.zettai_book || item == ZItems.zettai_scroll;
    }
}

