/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.spells.attack;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import zettasword.zettaimagic.system.ZItems;
import zettasword.zettaimagic.system.registers.Sounds;
import zettasword.zettaimagic.util.magic_lib.Mage;

public class IceBash
extends SpellRay {
    public static final String ICE_SHARDS = "ice_shards";

    public IceBash() {
        super("zettaimagic", "ice_bash", SpellActions.POINT, false);
        this.addProperties(new String[]{"effect_radius", ICE_SHARDS});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLivingBase) {
            world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, Sounds.spellbind, SoundCategory.MASTER, 0.5f, 1.0f, true);
            target.func_184185_a(Sounds.spellbind, 0.5f, 1.0f);
            if (!world.field_72995_K && BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)target.func_180425_c())) {
                this.freezeNearbyBlocks(world, origin, caster, modifiers);
            }
        }
        if (!world.field_72995_K) {
            Random rand = new Random();
            for (int i = 0; i < Spells.ice_charge.getProperty(ICE_SHARDS).intValue(); ++i) {
                double dx = rand.nextDouble() - 0.5;
                double dy = rand.nextDouble() - 0.5;
                double dz = rand.nextDouble() - 0.5;
                EntityIceShard iceshard = new EntityIceShard(world);
                iceshard.func_70107_b(target.field_70165_t + dx, target.field_70163_u + dy + 3.0, target.field_70161_v + dz);
                iceshard.field_70159_w = dx * 0.8;
                iceshard.field_70181_x = dy * 1.1;
                iceshard.field_70179_y = dz * 0.8;
                iceshard.setCaster(caster);
                iceshard.damageMultiplier = 5.0f;
                world.func_72838_d((Entity)iceshard);
            }
        } else {
            Mage.CircleCreate(Element.ICE, world, target.func_180425_c());
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
            this.freezeNearbyBlocks(world, origin, caster, modifiers);
            if (caster != null) {
                caster.func_184185_a(Sounds.spellbind, 0.5f, 1.0f);
            }
            Random rand = new Random();
            for (int i = 0; i < Spells.ice_charge.getProperty(ICE_SHARDS).intValue(); ++i) {
                double dx = rand.nextDouble() - 0.5;
                double dy = rand.nextDouble() - 0.5;
                double dz = rand.nextDouble() - 0.5;
                EntityIceShard iceshard = new EntityIceShard(world);
                iceshard.func_70107_b((double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy + 3.0, (double)pos.func_177952_p() + dz);
                iceshard.field_70159_w = dx * 3.0;
                iceshard.field_70181_x = dy * 3.0;
                iceshard.field_70179_y = dz * 3.0;
                iceshard.setCaster(caster);
                iceshard.damageMultiplier = 5.0f;
                world.func_72838_d((Entity)iceshard);
            }
        }
        if (world.field_72995_K) {
            Mage.CircleCreate(Element.ICE, world, pos);
        }
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
            this.freezeNearbyBlocks(world, origin, caster, modifiers);
        }
        return true;
    }

    private void freezeNearbyBlocks(World world, Vec3d origin, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
            double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
            for (int i = -((int)radius); i <= (int)radius; ++i) {
                for (int j = -((int)radius); j <= (int)radius; ++j) {
                    BlockPos pos = new BlockPos(origin).func_177982_a(i, 0, j);
                    Integer y = BlockUtils.getNearestSurface((World)world, (BlockPos)new BlockPos((Vec3i)pos), (EnumFacing)EnumFacing.UP, (int)((int)radius), (boolean)true, (BlockUtils.SurfaceCriteria)BlockUtils.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                    if (y == null) continue;
                    pos = new BlockPos(pos.func_177958_n(), y.intValue(), pos.func_177952_p());
                    double dist = origin.func_72438_d(new Vec3d(origin.field_72450_a + (double)i, (double)y.intValue(), origin.field_72449_c + (double)j));
                    if (y == -1 || !((double)world.field_73012_v.nextInt((int)(dist * 2.0) + 1) < radius) || !(dist < radius) || !BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)pos)) continue;
                    BlockUtils.freeze((World)world, (BlockPos)pos.func_177977_b(), (boolean)true);
                }
            }
        }
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        for (int i = 0; i < 3; ++i) {
            float r = world.field_73012_v.nextFloat();
            double speed = 0.007 / (double)r * (1.0 + world.field_73012_v.nextDouble());
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.CLOUD).pos(x, y, z).clr(0xFFFFFF).spin(world.field_73012_v.nextDouble() * 7.0 + 0.5, speed).shaded(true).time(20).spawn(world);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ZItems.zettai_book || item == ZItems.zettai_scroll;
    }
}

