/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.spells.defence;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import zettasword.zettaimagic.system.ZItems;
import zettasword.zettaimagic.util.MagicColor;

public class HolyBlindingFlash
extends SpellAreaEffect {
    public HolyBlindingFlash() {
        super("zettaimagic", "holy_blinding_flash", SpellActions.POINT_UP, false);
        this.alwaysSucceed(true);
        this.addProperties(new String[]{"effect_duration"});
    }

    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            int duration = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, duration, 0));
        }
        return true;
    }

    protected void spawnParticleEffect(World world, Vec3d origin, double radius, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        if (caster != null) {
            origin = origin.func_72441_c(0.0, (double)(caster.field_70131_O + 1.0f), 0.0);
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(origin).scale((float)radius * 0.8f).clr(MagicColor.Holy.getRed(), MagicColor.Holy.getGreen(), MagicColor.Holy.getBlue()).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == ZItems.zettai_book || item == ZItems.zettai_scroll;
    }
}

