/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.system.registers;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zettasword.zettaimagic.blocks.block.BlockInfMagicLight;
import zettasword.zettaimagic.blocks.block.MagicMarksBlock;
import zettasword.zettaimagic.blocks.block.ManaStabilizator;
import zettasword.zettaimagic.blocks.block.ProjectionBlock;
import zettasword.zettaimagic.blocks.tile.MagicMarksTile;
import zettasword.zettaimagic.blocks.tile.ManaStabiliser;
import zettasword.zettaimagic.blocks.tile.ProjectionTile;

@Mod.EventBusSubscriber(modid="zettaimagic")
public class BlocksRegistry {
    public static final Block MAGIC_PROJ = new ProjectionBlock();
    public static final Block INF_LIGHT = new BlockInfMagicLight();
    public static final Block STABILISER = new ManaStabilizator();
    public static final Block MAGIC_MARKS = new MagicMarksBlock();
    public static final Block[] BLOCKS = new Block[]{MAGIC_PROJ, INF_LIGHT, STABILISER, MAGIC_MARKS};

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BLOCKS);
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlocksRegistry.getItemBlocks(BLOCKS));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        BlocksRegistry.setRenderForAll(BLOCKS);
    }

    private static Item[] getItemBlocks(Block ... blocks) {
        Item[] items = new Item[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            items[i] = (Item)new ItemBlock(blocks[i]).setRegistryName(blocks[i].getRegistryName());
        }
        return items;
    }

    @SideOnly(value=Side.CLIENT)
    private static void setRenderForAll(Block ... blocks) {
        for (Block block : blocks) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
    }

    public static void registerTiles() {
        GameRegistry.registerTileEntity(ProjectionTile.class, (String)"magic_projection");
        GameRegistry.registerTileEntity(ManaStabiliser.class, (String)"mana_stabiliser");
        GameRegistry.registerTileEntity(MagicMarksTile.class, (String)"magic_marks");
    }
}

