/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.system.registers;

import electroblob.wizardry.Settings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zettasword.zettaimagic.entity.mob.EntityFairy;
import zettasword.zettaimagic.entity.mob.EntitySlimeMinion;
import zettasword.zettaimagic.entity.mob.EntityWanderingWizard;
import zettasword.zettaimagic.entity.projectile.ExplosionCataclysmMissile;
import zettasword.zettaimagic.entity.projectile.ExplosionMissile;
import zettasword.zettaimagic.entity.projectile.GrandMagicMissile;
import zettasword.zettaimagic.entity.projectile.GreatExplosionMissile;
import zettasword.zettaimagic.entity.projectile.GreatMagicMissile;
import zettasword.zettaimagic.entity.projectile.PreciseMagicMissile;
import zettasword.zettaimagic.system.ConfigHandler;

@GameRegistry.ObjectHolder(value="zettaimagic")
@Mod.EventBusSubscriber
public class EntityRegistry {
    private static final ResourceLocation[] wandering_blacklist = Settings.toResourceLocations((String[])new String[]{"mushroom_island", "mushroom_island_shore", "the_end", "small_end_islands", "end_midlands", "end_highlands", "end_barrens"});
    private static final ResourceLocation[] fairies_blacklist = Settings.toResourceLocations((String[])new String[]{"mushroom_island", "mushroom_island_shore", "the_end", "small_end_islands", "end_midlands", "end_highlands", "end_barrens"});
    private static int id = 0;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry reg = event.getRegistry();
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(PreciseMagicMissile.class, "precise_magic_missile", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(GreatMagicMissile.class, "great_magic_missile", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(GrandMagicMissile.class, "grand_magic_missile", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(ExplosionCataclysmMissile.class, "explosion_cataclysm_missile", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(ExplosionMissile.class, "explosion_missile", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(GreatExplosionMissile.class, "great_explosion_missile", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(EntitySlimeMinion.class, "slime_minion", TrackingType.LIVING).build());
        reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(EntityFairy.class, "fairy_", TrackingType.LIVING).egg(0x414141, 15063726).build());
        if (!Loader.isModLoaded((String)"arte_magicum") || ConfigHandler.ZettaiMagicConfig.entities.wandering_spawn != 0) {
            reg.register((IForgeRegistryEntry)EntityRegistry.createEntry(EntityWanderingWizard.class, "wandering_wizard", TrackingType.LIVING).egg(1648990, 15635218).spawn(EnumCreatureType.CREATURE, ConfigHandler.ZettaiMagicConfig.entities.wandering_spawn, 1, 1, new Biome[]{Biomes.field_150583_P, Biomes.field_76767_f, Biomes.field_76772_c, Biomes.field_150582_Q, Biomes.field_76787_r, Biomes.field_76774_n, Biomes.field_76769_d, Biomes.field_76789_p, Biomes.field_185444_T, Biomes.field_76768_g, Biomes.field_150588_X}).build());
        }
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, TrackingType tracking) {
        return EntityRegistry.createEntry(entityClass, name).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name) {
        ResourceLocation registryName = new ResourceLocation("zettaimagic", name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    static enum TrackingType {
        LIVING(80, 3, true),
        PROJECTILE(64, 10, true),
        CONSTRUCT(160, 10, false);

        int range;
        int interval;
        boolean trackVelocity;

        private TrackingType(int range, int interval, boolean trackVelocity) {
            this.range = range;
            this.interval = interval;
            this.trackVelocity = trackVelocity;
        }
    }
}

