/*
 * Decompiled with CFR 0.152.
 */
package zettasword.zettaimagic.util.magic_lib.classes;

import com.google.common.base.Predicate;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.IndirectMinionDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.MinionDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

@Mod.EventBusSubscriber
public interface IRenda
extends IEntityAdditionalSpawnData,
IEntityOwnable {
    public static final String NAMEPLATE_TRANSLATION_KEY = "entity.ebwizardry:summonedcreature.nameplate";

    public void setLifetime(int var1);

    public int getLifetime();

    public void setOwnerId(UUID var1);

    @Nullable
    public UUID func_184753_b();

    @Nullable
    default public Entity func_70902_q() {
        return this.getCaster();
    }

    @Nullable
    default public EntityLivingBase getCaster() {
        if (this instanceof Entity) {
            Entity entity = EntityUtils.getEntityByUUID((World)((Entity)this).field_70170_p, (UUID)this.func_184753_b());
            if (entity != null && !(entity instanceof EntityLivingBase)) {
                Wizardry.logger.warn("{} has a non-living owner!", (Object)this);
                return null;
            }
            return (EntityLivingBase)entity;
        }
        Wizardry.logger.warn("{} implements ISummonedCreature but is not an SoundLoopSpellEntity!", this.getClass());
        return null;
    }

    default public void setCaster(@Nullable EntityLivingBase caster) {
        this.setOwnerId(caster == null ? null : caster.func_110124_au());
    }

    default public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.getCaster() != null ? this.getCaster().func_145782_y() : -1);
        buffer.writeInt(this.getLifetime());
    }

    default public void readSpawnData(ByteBuf buffer) {
        int id = buffer.readInt();
        if (id > -1) {
            Entity entity = Wizardry.proxy.getTheWorld().func_73045_a(id);
            if (entity instanceof EntityLivingBase) {
                this.setCaster((EntityLivingBase)entity);
            } else {
                Wizardry.logger.warn("Received a spawn packet for entity {}, but no living entity matched the supplied ID", (Object)this);
            }
        }
        this.setLifetime(buffer.readInt());
    }

    default public boolean isValidTarget(Entity target) {
        if (AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), (Entity)target)) {
            if (target instanceof EntityPlayer) {
                return !(this.getCaster() instanceof EntityWizard) || this.getCaster().func_70643_av() == target || ((EntityWizard)this.getCaster()).func_70638_az() == target;
            }
            if ((target instanceof IMob || target instanceof ISummonedCreature || target instanceof EntityWizard && !(this.getCaster() instanceof EntityWizard) || target instanceof EntityLiving && ((EntityLiving)target).func_70638_az() == this.getCaster() || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(target.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(target.getClass()))) {
                return true;
            }
        }
        return false;
    }

    default public Predicate<Entity> getTargetSelector() {
        return entity -> !entity.func_82150_aj() && (this.getCaster() == null ? entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_() : this.isValidTarget((Entity)entity));
    }

    public void onSpawn();

    public void onDespawn();

    public boolean hasParticleEffect();

    default public boolean hasAnimation() {
        return true;
    }

    default public int getAnimationColour(float animationProgress) {
        return 0;
    }

    default public void onSuccessfulAttack(EntityLivingBase target) {
    }

    default public void writeNBTDelegate(NBTTagCompound tagcompound) {
        if (this.getCaster() != null) {
            tagcompound.func_186854_a("casterUUID", this.getCaster().func_110124_au());
        }
        tagcompound.func_74768_a("lifetime", this.getLifetime());
    }

    default public void readNBTDelegate(NBTTagCompound tagcompound) {
        this.setOwnerId(tagcompound.func_186857_a("casterUUID"));
        this.setLifetime(tagcompound.func_74762_e("lifetime"));
    }

    default public boolean shouldRevengeTarget(EntityLivingBase entity) {
        return Wizardry.settings.minionRevengeTargeting || this.isValidTarget((Entity)entity);
    }

    default public void updateDelegate() {
        if (!(this instanceof Entity)) {
            throw new ClassCastException("Implementations of ISummonedCreature must extend SoundLoopSpellEntity!");
        }
        Entity thisEntity = (Entity)this;
        if (thisEntity.field_70173_aa == 1) {
            this.onSpawn();
        }
        if (thisEntity.field_70173_aa > this.getLifetime() && this.getLifetime() > 0) {
            this.onDespawn();
            thisEntity.func_70106_y();
        }
        if (this.hasParticleEffect() && thisEntity.field_70170_p.field_72995_K && thisEntity.field_70170_p.field_73012_v.nextInt(8) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(thisEntity.field_70165_t, thisEntity.field_70163_u + thisEntity.field_70170_p.field_73012_v.nextDouble() * 1.5, thisEntity.field_70161_v).clr(0.1f, 0.0f, 0.0f).spawn(thisEntity.field_70170_p);
        }
    }

    default public boolean interactDelegate(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        WizardData data = WizardData.get((EntityPlayer)player);
        if (player.func_70093_af() && stack.func_77973_b() instanceof ISpellCastingItem) {
            if (!player.field_70170_p.field_72995_K && data != null && this.getCaster() == player) {
                data.selectedMinion = data.selectedMinion != null && data.selectedMinion.get() == this ? null : new WeakReference<IRenda>(this);
                data.sync();
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        EntityLivingBase summoner;
        if (event.getSource().func_76346_g() instanceof ISummonedCreature && (summoner = ((ISummonedCreature)event.getSource().func_76346_g()).getCaster()) != null) {
            boolean isRetaliatory;
            event.setCanceled(true);
            DamageSource newSource = event.getSource();
            MagicDamage.DamageType type = event.getSource() instanceof IElementalDamage ? ((IElementalDamage)event.getSource()).getType() : MagicDamage.DamageType.MAGIC;
            boolean bl = isRetaliatory = event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory();
            if (event.getSource() instanceof EntityDamageSourceIndirect) {
                newSource = new IndirectMinionDamage(event.getSource().field_76373_n, event.getSource().func_76364_f(), event.getSource().func_76346_g(), (Entity)summoner, type, isRetaliatory);
            } else if (event.getSource() instanceof EntityDamageSource) {
                newSource = new MinionDamage(event.getSource().field_76373_n, event.getSource().func_76346_g(), (Entity)summoner, type, isRetaliatory);
            }
            if (event.getSource().func_94541_c()) {
                newSource.func_94540_d();
            }
            if (event.getSource().func_76347_k()) {
                newSource.func_76361_j();
            }
            if (event.getSource().func_76352_a()) {
                newSource.func_76349_b();
            }
            if (DamageSafetyChecker.attackEntitySafely((Entity)event.getEntity(), (DamageSource)newSource, (float)event.getAmount(), (DamageSource)event.getSource(), (boolean)false)) {
                EntityUtils.applyStandardKnockback((Entity)event.getSource().func_76346_g(), (EntityLivingBase)event.getEntityLiving());
                ((ISummonedCreature)event.getSource().func_76346_g()).onSuccessfulAttack(event.getEntityLiving());
                if (event.getEntityLiving().func_70643_av() == summoner && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                    event.getEntityLiving().func_70604_c((EntityLivingBase)event.getSource().func_76346_g());
                }
            }
        }
    }
}

