/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.core;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.network.Connection;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.types.ParticleType;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ForgeMod {
    protected final List<Runnable> postInitRunnables = new ArrayList<Runnable>();
    protected final Logger logger = LogManager.getLogger((String)this.getId());
    protected final Connection connection = new Connection(this.getId(), this.getRequiredSide());

    public abstract String getId();

    protected ForgeMod() {
        IEventBus modEventBus = this.getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addGenericListener(Block.class, event -> this.registerBlocks());
        modEventBus.addGenericListener(Item.class, event -> this.registerItems());
        modEventBus.addGenericListener(EntityType.class, event -> this.registerEntities());
        modEventBus.addGenericListener(TileEntityType.class, event -> this.registerTiles());
        modEventBus.addGenericListener(ParticleType.class, event -> this.registerParticles());
        modEventBus.addListener(event -> this.commonInit());
        modEventBus.addListener(event -> event.enqueueWork(this::commonPostInit));
        forgeEventBus.addListener(event -> this.updateReloadedTags());
        this.registerConfig(ModConfig.Type.COMMON, this::commonConfigInit);
        forgeEventBus.addListener(event -> this.serverAboutToStart(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStarting(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStopped(event.getServer()));
        forgeEventBus.addListener(event -> this.registerCommands(ServerCommand.createFor(this, (CommandDispatcher<CommandSource>)event.getDispatcher())));
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(event -> this.clientInit());
            modEventBus.addListener(event -> this.clientReplaceModels(new ItemModel.RegistryWrapper(event.getModelRegistry())));
            modEventBus.addListener(event -> this.clientRegisterParticleFactories(Minecraft.func_71410_x().field_71452_i));
            modEventBus.addListener(event -> event.enqueueWork(() -> this.clientRegisterItemModelProperties(ItemModel.Properties.of(this))));
            this.registerConfig(ModConfig.Type.CLIENT, this::clientConfigInit);
        }
    }

    public IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    public abstract void commonInit();

    public void commonPostInit() {
        this.postInitRunnables.forEach(action -> action.run());
    }

    public void commonConfigInit(ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ConfigValueBuilder value) {
    }

    @Deprecated
    public void registerBlocks() {
    }

    @Deprecated
    public void registerItems() {
    }

    @Deprecated
    public void registerEntities() {
    }

    @Deprecated
    public void registerTiles() {
    }

    @Deprecated
    public void registerParticles() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterParticleFactories(ParticleManager manager) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
    }

    public void registerCommands(ServerCommand command) {
    }

    public void updateReloadedTags() {
    }

    protected void serverAboutToStart(MinecraftServer server) {
    }

    protected void serverStarting(MinecraftServer server) {
    }

    protected void serverStopped(MinecraftServer server) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public RequiredSide getRequiredSide() {
        return RequiredSide.BOTH;
    }

    public void runDuringPostInit(Runnable method) {
        this.postInitRunnables.add(method);
    }

    protected <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(Supplier<MSG> factory) {
        this.getConnection().registerNetMessage((ForgeNetMsg)factory.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends Entity> void registerEntityRender(EntityType<T> entityType, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityType, renderFactory);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends TileEntity> void registerTileRenderer(TileEntityType<T> tileEntityType, Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super T>> rendererFactory) {
        ClientRegistry.bindTileEntityRenderer(tileEntityType, rendererFactory);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <M extends Container, U extends Screen> void registerContainerScreen(ContainerType<? extends M> type, ScreenManager.IScreenFactory<M, U> factory) {
        ScreenManager.func_216911_a(type, factory);
    }

    @Deprecated
    protected <E extends IForgeRegistryEntry<E>> E registerForgeEntry(IForgeRegistry<E> registry, E entry, String name) {
        if (entry instanceof IForgeUnit) {
            ((IForgeUnit)entry).saveConfig();
        }
        if (entry.getRegistryName() == null) {
            ResourceLocation regName = new ResourceLocation(this.getId(), name);
            entry.setRegistryName(regName);
        }
        registry.register(entry);
        return entry;
    }

    @Deprecated
    protected <T extends Block> T registerBlock(T block) {
        this.registerForgeEntry((IForgeRegistry)ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block, block.getRegistryName().func_110623_a());
        return block;
    }

    @Deprecated
    protected <T extends Item> T registerItem(T item) {
        this.registerForgeEntry((IForgeRegistry)ForgeRegistries.ITEMS, (IForgeRegistryEntry)item, item.getRegistryName().func_110623_a());
        return item;
    }

    @Deprecated
    protected <T extends BlockItem> T registerBlockItem(T item) {
        String name = item.func_179223_d().getRegistryName().func_110623_a();
        this.registerForgeEntry((IForgeRegistry)ForgeRegistries.ITEMS, (IForgeRegistryEntry)item, name);
        return item;
    }

    @Deprecated
    protected <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder) {
        EntityType type = builder.func_206830_a(null);
        this.registerForgeEntry(ForgeRegistries.ENTITIES, type, name);
        return type;
    }

    @Deprecated
    protected <T extends TileEntity> TileEntityType<T> registerTile(String name, TileEntityType.Builder<T> builder) {
        TileEntityType type = builder.func_206865_a(null);
        this.registerForgeEntry(ForgeRegistries.TILE_ENTITIES, type, name);
        return type;
    }

    @Deprecated
    protected <T extends IParticleData> com.endertech.minecraft.forge.types.ParticleType<T> registerParticle(String name, ParticleType.Builder<T> builder) {
        com.endertech.minecraft.forge.types.ParticleType<T> type = builder.build();
        this.registerForgeEntry((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (IForgeRegistryEntry)type, name);
        return type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Block block, RenderType type) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Fluid fluid, RenderType type) {
        RenderTypeLookup.setRenderLayer((Fluid)fluid, (RenderType)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addPlayerRenderLayer(Function<PlayerRenderer, LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>> layerRendererFactory) {
        Collection renderers = Minecraft.func_71410_x().func_175598_ae().getSkinMap().values();
        renderers.forEach(renderer -> renderer.func_177094_a((LayerRenderer)layerRendererFactory.apply((PlayerRenderer)renderer)));
    }

    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public Path getConfigsDir() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getId());
    }

    public ResourceLocation namespaced(String resourceName) {
        return new ResourceLocation(this.getId(), resourceName);
    }

    protected void registerConfig(ModConfig.Type type, Consumer<ConfigValueBuilder> init) {
        ConfigValueBuilder value = new ConfigValueBuilder();
        init.accept(value);
        ModLoadingContext.get().registerConfig(type, value.builder.build());
    }

    public static class ConfigValueBuilder {
        public final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        public ConfigValueBuilder push(String path) {
            this.builder.push(path);
            return this;
        }

        public ConfigValueBuilder pop() {
            this.builder.pop();
            return this;
        }

        public ConfigValueBuilder comment(String comment) {
            this.builder.comment(comment);
            return this;
        }

        public ForgeConfigSpec.ConfigValue<Boolean> define(String path, boolean defaultValue) {
            return this.builder.define(path, defaultValue);
        }

        public ForgeConfigSpec.ConfigValue<Integer> define(String path, ColorARGB defaultValue) {
            return this.builder.define(path, (Object)defaultValue.getARGB());
        }

        public ForgeConfigSpec.ConfigValue<Integer> defineInRange(String path, int defaultValue, IntBounds bounds) {
            return this.builder.defineInRange(path, defaultValue, bounds.min.intValue(), bounds.max.intValue());
        }

        public ForgeConfigSpec.ConfigValue<Double> defineInRange(String path, float defaultValue, FloatBounds bounds) {
            return this.builder.defineInRange(path, (double)defaultValue, (double)bounds.min.floatValue(), (double)bounds.max.floatValue());
        }
    }

    public static enum RequiredSide {
        SERVER,
        CLIENT,
        BOTH;

    }
}

