/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;

public class ServerCommand {
    protected final LiteralArgumentBuilder<CommandSource> builder;
    protected final CommandDispatcher<CommandSource> dispatcher;
    protected final List<Task> tasks = new ArrayList<Task>();

    public ServerCommand(String name, CommandDispatcher<CommandSource> dispatcher) {
        this.builder = Commands.func_197057_a((String)name);
        this.dispatcher = dispatcher;
    }

    public static ServerCommand createFor(ForgeMod mod, CommandDispatcher<CommandSource> dispatcher) {
        String commandName = mod.getId().replaceFirst("^ad", "");
        return new ServerCommand(commandName, dispatcher);
    }

    @Deprecated
    public static ServerCommand createFor(ForgeMod mod, MinecraftServer server) {
        return ServerCommand.createFor(mod, (CommandDispatcher<CommandSource>)server.func_195571_aL().func_197054_a());
    }

    public Task task(String name) {
        Task task = new Task(name);
        this.tasks.add(task);
        return task;
    }

    public ServerCommand requires(OpLevel level) {
        this.builder.requires(src -> src.func_197034_c(level.ordinal() + 1));
        return this;
    }

    public void register() {
        for (Task task : this.tasks) {
            this.builder.then(task.builder);
        }
        this.dispatcher.register(this.builder);
    }

    public static class Arg<T> {
        public final String name;
        public final ArgumentType<T> type;

        public Arg(String name, ArgumentType<T> type) {
            this.name = name;
            this.type = type;
        }

        public static <T> Arg<T> of(String name, ArgumentType<T> type) {
            return new Arg<T>(name, type);
        }

        public static Arg<Integer> integer(String name, IntBounds bounds) {
            return Arg.of(name, IntegerArgumentType.integer((int)bounds.min, (int)bounds.max));
        }

        public static Arg<Float> floatt(String name, FloatBounds bounds) {
            return Arg.of(name, FloatArgumentType.floatArg((float)bounds.min.floatValue(), (float)bounds.max.floatValue()));
        }

        public static Arg<String> string(String name) {
            return Arg.of(name, StringArgumentType.string());
        }

        public static Arg<String> word(String name) {
            return Arg.of(name, StringArgumentType.word());
        }

        public static Arg<IntBounds> bounds(String name, IntBounds bounds) {
            return Arg.of(name, IntBoundsArgument.bounded(bounds));
        }

        public static Arg<FloatBounds> bounds(String name, FloatBounds bounds) {
            return Arg.of(name, FloatBoundsArgument.bounded(bounds));
        }

        public static Arg<ColorARGB> color(String name) {
            return Arg.of(name, new ColorARGBArgument());
        }
    }

    public static class ColorARGBArgument
    implements ArgumentType<ColorARGB> {
        static final Collection<String> EXAMPLES = Arrays.asList("0xaarrggbb", "0x11223344");

        public static ColorARGB getValue(CommandContext<CommandSource> context, String name) {
            return (ColorARGB)context.getArgument(name, ColorARGB.class);
        }

        public ColorARGB parse(StringReader reader) throws CommandSyntaxException {
            int start = reader.getCursor();
            String argument = reader.readString();
            try {
                return ColorARGB.parse(argument);
            }
            catch (NumberFormatException ex) {
                reader.setCursor(start);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)argument);
            }
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class FloatBoundsArgument
    implements ArgumentType<FloatBounds> {
        static final Collection<String> EXAMPLES = Arrays.asList("min_max", "number1_number2", "0.5_100.5");
        protected final FloatArgumentType min;
        protected final FloatArgumentType max;

        protected FloatBoundsArgument(FloatBounds bounds) {
            this.min = FloatArgumentType.floatArg((float)bounds.min.floatValue(), (float)bounds.max.floatValue());
            this.max = FloatArgumentType.floatArg((float)bounds.min.floatValue(), (float)bounds.max.floatValue());
        }

        public static FloatBoundsArgument unbounded() {
            return new FloatBoundsArgument(FloatBounds.FLOAT);
        }

        public static FloatBoundsArgument positive() {
            return new FloatBoundsArgument(FloatBounds.FLOAT_POSITIVE);
        }

        public static FloatBoundsArgument bounded(FloatBounds bounds) {
            return new FloatBoundsArgument(bounds);
        }

        public FloatBounds parse(StringReader reader) throws CommandSyntaxException {
            float min = this.min.parse(reader).floatValue();
            reader.expect('_');
            float max = this.max.parse(reader).floatValue();
            return FloatBounds.from(Float.valueOf(min), Float.valueOf(max));
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class IntBoundsArgument
    implements ArgumentType<IntBounds> {
        protected static final Collection<String> EXAMPLES = Arrays.asList("min_max", "number1_number2", "0_100");
        protected final IntegerArgumentType min;
        protected final IntegerArgumentType max;

        protected IntBoundsArgument(IntBounds bounds) {
            this.min = IntegerArgumentType.integer((int)bounds.min, (int)bounds.max);
            this.max = IntegerArgumentType.integer((int)bounds.min, (int)bounds.max);
        }

        public static IntBoundsArgument integer() {
            return new IntBoundsArgument(IntBounds.INTEGER);
        }

        public static IntBoundsArgument positive() {
            return new IntBoundsArgument(IntBounds.INTEGER_POSITIVE);
        }

        public static IntBoundsArgument bounded(IntBounds bounds) {
            return new IntBoundsArgument(bounds);
        }

        public IntBounds parse(StringReader reader) throws CommandSyntaxException {
            int min = this.min.parse(reader);
            reader.expect('_');
            int max = this.max.parse(reader);
            return IntBounds.from(min, max);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }

    public static class Context {
        protected final CommandContext<CommandSource> context;
        public final CommandSource source;

        public Context(CommandContext<CommandSource> context) {
            this.context = context;
            this.source = (CommandSource)context.getSource();
        }

        public ServerWorld getWorld() {
            return this.source.func_197023_e();
        }

        public BlockPos getBlockPos() {
            return new BlockPos(this.source.func_197036_d());
        }

        public void sendMessage(String msg) {
            this.source.func_197030_a((ITextComponent)new StringTextComponent(msg), false);
        }

        @Nullable
        public Entity getEntity() {
            return this.source.func_197022_f();
        }

        public <V> V getArgument(String name, Class<V> type) {
            return (V)this.context.getArgument(name, type);
        }
    }

    public static class Task {
        protected final LiteralArgumentBuilder<CommandSource> builder;

        public Task(String name) {
            this.builder = Commands.func_197057_a((String)name);
        }

        protected Command<CommandSource> asCommand(Consumer<Context> method) {
            return context -> {
                method.accept(new Context((CommandContext<CommandSource>)context));
                return 1;
            };
        }

        public Task executes(Consumer<Context> method, Arg<?> ... arguments) {
            RequiredArgumentBuilder arg = null;
            for (int i = arguments.length - 1; i >= 0; --i) {
                RequiredArgumentBuilder builder = Commands.func_197056_a((String)arguments[i].name, arguments[i].type);
                if (arg != null) {
                    builder.then(arg);
                } else {
                    builder.executes(this.asCommand(method));
                }
                arg = builder;
            }
            if (arg != null) {
                this.builder.then(arg);
            } else {
                this.builder.executes(this.asCommand(method));
            }
            return this;
        }

        public Task executes(Consumer<Context> method, String argName) {
            this.builder.then(Commands.func_197057_a((String)argName).executes(this.asCommand(method)));
            return this;
        }
    }

    public static enum OpLevel {
        NOOB,
        NORMAL,
        KICKASS,
        GOD;

    }
}

