/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.entities.ForgeTileEntity;
import com.endertech.minecraft.forge.tiles.TileInventory;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public abstract class ForgeTileWithInventory
extends ForgeTileEntity
implements INamedContainerProvider {
    protected final LazyOptional<TileInventory> inventoryHolder = LazyOptional.of(() -> this.getTileInventory());
    protected final LazyOptional<RangedWrapper> inputHolder = LazyOptional.of(() -> this.createInput(this.getTileInventory()));
    protected final LazyOptional<RangedWrapper> outputHolder = LazyOptional.of(() -> this.createOutput(this.getTileInventory()));

    public ForgeTileWithInventory(TileEntityType<?> type) {
        super(type);
    }

    public abstract TileInventory getTileInventory();

    protected abstract RangedWrapper createInput(TileInventory var1);

    protected abstract RangedWrapper createOutput(TileInventory var1);

    @Nullable
    protected abstract Container createContainer(int var1, PlayerEntity var2, PlayerInventory var3, TileInventory var4);

    @Nullable
    public final Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return this.createContainer(id, player, playerInventory, this.getTileInventory());
    }

    public void openGuiScreenFor(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.getTileInventory().deserializeNBT(compound.func_74775_l("inv"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inv", (INBT)this.getTileInventory().serializeNBT());
        return compound;
    }

    public boolean canInteractWith(PlayerEntity player) {
        return !this.func_145837_r() && this.func_174877_v().func_218138_a((IPosition)player.func_213303_ch(), true) <= 64.0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryHolder.invalidate();
        this.inputHolder.invalidate();
        this.outputHolder.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        return super.getCapability(cap, side);
    }
}

