/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.GamePath;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Dimension;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class TileInventory
extends ItemStackHandler {
    protected final TileEntity tile;

    public TileInventory(TileEntity tile, int size) {
        super(size);
        this.tile = tile;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    protected void onContentsChanged(int slot) {
        this.tile.func_70296_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class AbstractScreen<T extends Container>
    extends ContainerScreen<T> {
        protected final GuiTexture texture;

        public AbstractScreen(T container, PlayerInventory inv, ITextComponent title, GuiTexture texture) {
            super(container, inv, title);
            this.texture = texture;
            this.field_146999_f = texture.size.width;
            this.field_147000_g = texture.size.height;
        }

        public GuiTexture getTexture() {
            return this.texture;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(matrixStack);
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.func_230459_a_(matrixStack, mouseX, mouseY);
        }

        protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
            GameRendering.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(this.texture.location);
            int i = (this.field_230708_k_ - this.field_146999_f) / 2;
            int j = (this.field_230709_l_ - this.field_147000_g) / 2;
            this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        }

        public static class GuiTexture {
            public final Dimension size;
            public final ResourceLocation location;

            public GuiTexture(ForgeMod mod, String name, int width, int height) {
                this.location = GamePath.guiTexture((ResourceLocation)mod.namespaced((String)name), (String[])new String[0]).location;
                this.size = new Dimension(width, height);
            }
        }
    }

    public static abstract class AbstractContainer
    extends Container {
        public static final Dimension PLAYER_INVENTORY = new Dimension(9, 3);
        public static final Dimension SLOT_SIZE = new Dimension(18, 18);
        protected final PlayerMainInvWrapper playerInventory;
        protected final TileInventory tileInventory;

        public AbstractContainer(ContainerType<?> type, int id, PlayerInventory playerInventory, TileInventory tileInventory) {
            super(type, id);
            this.playerInventory = new PlayerMainInvWrapper(playerInventory);
            this.tileInventory = tileInventory;
        }

        public PlayerMainInvWrapper getPlayerInventory() {
            return this.playerInventory;
        }

        public TileInventory getTileInventory() {
            return this.tileInventory;
        }

        public AbstractContainer addPlayerSlots(int startX, int startY) {
            for (int row = 0; row < AbstractContainer.PLAYER_INVENTORY.height; ++row) {
                for (int col = 0; col < AbstractContainer.PLAYER_INVENTORY.width; ++col) {
                    int x = startX + col * this.slotSize().width;
                    int y = startY + row * this.slotSize().height;
                    this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.playerInventory, AbstractContainer.PLAYER_INVENTORY.width + col + row * AbstractContainer.PLAYER_INVENTORY.width, x, y));
                }
            }
            for (int col = 0; col < AbstractContainer.PLAYER_INVENTORY.width; ++col) {
                int x = startX + col * this.slotSize().width;
                int y = startY + 58;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.playerInventory, col, x, y));
            }
            return this;
        }

        public Dimension slotSize() {
            return SLOT_SIZE;
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                int size = this.tileInventory.getSlots();
                if (index < size ? !this.func_75135_a(itemstack1, size, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, size, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
            }
            return itemstack;
        }

        public boolean func_75145_c(PlayerEntity player) {
            TileEntity tile = this.getTileInventory().getTile();
            World world = tile.func_145831_w();
            BlockPos pos = tile.func_174877_v();
            Block block = tile.func_195044_w().func_177230_c();
            return AbstractContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos), (PlayerEntity)player, (Block)block);
        }
    }

    public static class ItemSlot
    extends SlotItemHandler {
        public final TileInventory tileInventory;

        public ItemSlot(TileInventory tileInventory, int index, int xPosition, int yPosition) {
            super((IItemHandler)tileInventory, index, xPosition, yPosition);
            this.tileInventory = tileInventory;
        }
    }
}

