/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import java.util.Objects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class DimensionId {
    protected final RegistryKey<World> key;

    protected DimensionId(RegistryKey<World> registryKey) {
        this.key = registryKey;
    }

    public static DimensionId from(RegistryKey<World> registryKey) {
        return new DimensionId(registryKey);
    }

    public static DimensionId from(World world) {
        return new DimensionId((RegistryKey<World>)world.func_234923_W_());
    }

    public static DimensionId from(ResourceLocation location) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)location);
        return new DimensionId((RegistryKey<World>)key);
    }

    public boolean belongsTo(World world) {
        return this.getKey().equals((Object)world.func_234923_W_());
    }

    public RegistryKey<World> getKey() {
        return this.key;
    }

    public ResourceLocation toResourceLocation() {
        return this.getKey().func_240901_a_();
    }

    public String toString() {
        return this.toResourceLocation().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionId) {
            return Objects.equals(this.getKey(), ((DimensionId)obj).getKey());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }
}

