/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.data.JsonGen;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.mods.adchimneys.Commands;
import com.endertech.minecraft.mods.adchimneys.blocks.Pump;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import com.endertech.minecraft.mods.adchimneys.init.Emitters;
import com.endertech.minecraft.mods.adchimneys.init.Items;
import com.endertech.minecraft.mods.adchimneys.init.MaterialGroup;
import com.endertech.minecraft.mods.adchimneys.init.MaterialType;
import com.endertech.minecraft.mods.adchimneys.init.Particles;
import com.endertech.minecraft.mods.adchimneys.init.Tiles;
import com.endertech.minecraft.mods.adchimneys.network.EmitterPosMsg;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import com.endertech.minecraft.mods.adchimneys.particles.ModernSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.particles.RetroSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.nio.file.Path;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adchimneys")
public class AdChimneys
extends ForgeMod {
    public static final String ID = "adchimneys";
    public static final String NAME = "Advanced Chimneys";
    private static AdChimneys instance;
    public final Emitters emitters;
    public final Blocks blocks;
    public final Items items;
    public final Particles particles;
    public final Tiles tiles;

    public AdChimneys() {
        instance = this;
        this.blocks = new Blocks(this);
        this.items = new Items(this);
        this.emitters = new Emitters(this);
        this.particles = new Particles(this);
        this.tiles = new Tiles(this);
    }

    public static AdChimneys getInstance() {
        return instance;
    }

    public static void main(String ... args) throws Exception {
        JsonGen.LangFile langFile = JsonGen.langFile((String)ID, (Locale)Locale.US);
        langFile.begin();
        for (ISmokeContainer.Type type : ISmokeContainer.Type.values()) {
            String groupName = type.getName() + "s";
            langFile.addItemGroup(groupName, CommonString.capitalizeFirstChar((String)groupName));
            for (MaterialType material : MaterialType.values()) {
                ResourceLocation regName = new ResourceLocation(ID, material.getNameFor(type));
                ResourceLocation parent = new ResourceLocation(ID, type.getName());
                boolean madeOfGlass = regName.func_110623_a().contains("glass");
                JsonGen.blockState((ResourceLocation)regName);
                JsonGen.blockModel((ResourceLocation)regName, (ResourceLocation)parent, (ResourceLocation)material.texture);
                if (!madeOfGlass) {
                    ((JsonGen.LootTableFile)JsonGen.blockLootTable((ResourceLocation)regName).begin()).beginPool(1).addItem(regName).addCondition(JsonGen.LootTableFile.Condition.SURVIVES_EXPLOSION).endPool().end();
                }
                JsonGen.itemModel((ResourceLocation)regName);
                langFile.addBlock(regName);
                if (type != ISmokeContainer.Type.CHIMNEY && madeOfGlass) continue;
                JsonGen.RecipeFile recipe = (JsonGen.RecipeFile)JsonGen.recipeFile((ResourceLocation)regName).begin();
                switch (type) {
                    case CHIMNEY: {
                        recipe.pattern(new String[]{"M M", "M M", "M M"}).addItem("M", material.id.toResLoc()).result(regName, material.count);
                        break;
                    }
                    case VENT: {
                        ResourceLocation chimney = new ResourceLocation(ID, material.getNameFor(ISmokeContainer.Type.CHIMNEY));
                        recipe.pattern(new String[]{"H H", "   ", "H H"}).addItem("H", chimney).result(regName, 4);
                        break;
                    }
                    case PUMP: {
                        ResourceLocation vent = new ResourceLocation(ID, material.getNameFor(ISmokeContainer.Type.VENT));
                        recipe.pattern(new String[]{"#R#", "RVR", "#R#"}).addItem("#", vent).addItem("R", new ResourceLocation("minecraft:repeater")).addItem("V", new ResourceLocation("minecraft:hopper")).result(regName, 4);
                    }
                }
                recipe.end();
            }
        }
        langFile.end();
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(SmokePosMsg::new);
        this.registerNetMessage(EmitterPosMsg::new);
    }

    protected void serverStarting(MinecraftServer server) {
        super.serverStarting(server);
    }

    public void commonConfigInit(ForgeMod.ConfigValueBuilder value) {
        value.push("Smoke");
        Smoke.defaultColor = value.comment("Default smoke color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)").define("defaultColor", ColorARGB.DEFAULT);
        Smoke.maxAmount = value.comment("Maximum smoke particles amount per chimney").defineInRange("maxAmount", 16, IntBounds.from((Integer)1, (Integer)100));
        Smoke.maxIntensity = value.comment("Maximum smoke blow out distance").defineInRange("maxIntencity", 4.0f, FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(20.0f)));
        Smoke.maxScale = value.comment("Maximum smoke particles scale").defineInRange("maxScale", 2.5f, FloatBounds.from((Float)Float.valueOf(1.0f), (Float)Float.valueOf(10.0f)));
        Smoke.maxRenderDistance = value.comment("Maximum smoke particles render distance").defineInRange("maxRenderDistance", 128, IntBounds.from((Integer)16, (Integer)256));
        value.pop();
        UnitConfig config = UnitConfig.in((Path)this.getConfigsDir(), (String)"Pumps");
        String category = "Pump";
        Pump.energyStorageProps = ForgeEnergy.StorageProps.create((UnitConfig)config, (String)category, (boolean)false, (int)10000, (int)50);
        Pump.invertedRedstronSignal = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"invertedRedstoneSignal", (boolean)false, (String)"If set to True, the redstone signal will turn the pump off instead of turning it on");
        config.save();
    }

    public void clientConfigInit(ForgeMod.ConfigValueBuilder value) {
        value.push("Smoke");
        Smoke.coloringFactor = value.comment("Affects probability of coloring smoke by chimneys").defineInRange("coloringFactor", 0.1f, GameBounds.FACTOR.getFloatBounds());
        Smoke.maxRenderedParticlesAmount = value.comment("Maximum smoke particles that can be rendered at scene.\nIf exceeded, smoke amount will be reduced proportionally for each rendered chimney").defineInRange("maxRenderedParticlesAmount", 800, IntBounds.from((Integer)0, (Integer)2000));
        Smoke.canCollide = value.comment("If true, smoke particles will collide with obstacles").define("canCollide", true);
        Smoke.emitWithoutChimney = value.comment("If true, all emitters will produce smoke even without connected chimneys").define("emitWithoutChimney", true);
        Smoke.retroParticles = value.comment("Use retro smoke particles instead of modern ones").define("retroSmokeParticles", false);
        Smoke.disableVanillaCampfireSmoke = value.comment("Completely disables vanilla cozy smoke particles from a campfire").define("disableVanillaCampfireSmoke", true);
        Smoke.colorize = value.comment("Whether or not to colorize smoke particles").define("colorize", true);
        value.pop();
        value.push("MaterialGroups");
        for (MaterialGroup group : MaterialGroup.values()) {
            String name = CommonString.capitalizeFirstChar((String)group.getName());
            value.push(name);
            group.enabled = value.comment("Whether to display this group of blocks or not").define("enabled", true);
            value.pop();
        }
        value.pop();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        for (MaterialType type : MaterialType.values()) {
            if (type.chimney.isOpaqueMaterial(type.chimney.func_176223_P())) {
                RenderTypeLookup.setRenderLayer((Block)type.chimney, (RenderType)RenderType.func_228641_d_());
            } else {
                RenderTypeLookup.setRenderLayer((Block)type.chimney, (RenderType)RenderType.func_228645_f_());
            }
            RenderTypeLookup.setRenderLayer((Block)type.pump, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)type.vent, (RenderType)RenderType.func_228641_d_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterParticleFactories(ParticleManager manager) {
        manager.func_215234_a(this.particles.retro, RetroSmokeParticle.Factory::new);
        manager.func_215234_a(this.particles.modern, ModernSmokeParticle.Factory::new);
    }

    public void updateReloadedTags() {
        this.postInitRunnables.forEach(action -> action.run());
        super.updateReloadedTags();
    }

    public void registerCommands(ServerCommand command) {
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list").executes(Commands::listEmitters, "emitters");
        command.task("identify").executes(Commands::identifyEmitter, "emitter").executes(Commands::identifyBlock, "block").executes(Commands::identifyTile, "tile");
        command.task("reload").executes(Commands::reloadEmitters, "emitters");
        command.task("stats").executes(Commands::showStats, new ServerCommand.Arg[0]);
        command.register();
    }
}

