/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.world.Stats;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class Commands {
    private static float reachDistance = 5.0f;

    public static void reloadEmitters(ServerCommand.Context context) {
        AdChimneys.getInstance().emitters.reloadConfigs();
        context.sendMessage("Configs for emitters reloaded");
    }

    public static void identifyEmitter(ServerCommand.Context context) {
        BlockPos pos;
        ServerWorld world;
        Emitter emitter;
        Optional<Pair<BlockPos, String>> info = Commands.getTargetBlockInfo(context, false);
        if (info.isPresent() && (emitter = AdChimneys.getInstance().emitters.findBy((IWorldReader)(world = context.getWorld()), pos = (BlockPos)info.get().getKey())) != null) {
            context.sendMessage(Commands.coloredEmitter((String)info.get().getValue(), (IEmitter)emitter, emitter.isActive((IWorldReader)world, pos)));
            return;
        }
        context.sendMessage(Commands.coloredError("No emitter found"));
    }

    public static void identifyBlock(ServerCommand.Context context) {
        Commands.getTargetBlockInfo(context, true).ifPresent(info -> context.sendMessage((String)info.getValue()));
    }

    public static void identifyTile(ServerCommand.Context context) {
        ServerWorld world = context.getWorld();
        Optional<Pair<BlockPos, String>> info = Commands.getTargetBlockInfo(context, true);
        if (info.isPresent()) {
            BlockPos pos = (BlockPos)info.get().getKey();
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                UnitId id = UnitId.from((ResourceLocation)tile.func_200662_C().getRegistryName());
                context.sendMessage(Commands.coloredUnit("Target tile", TextFormatting.BLUE, id) + " of " + Commands.coloredClass(tile.getClass(), true) + " with " + Commands.coloredNbtTags((INBTSerializable<CompoundNBT>)tile));
            } else {
                context.sendMessage((String)info.get().getValue() + Commands.coloredError(" has no tile"));
            }
        }
    }

    public static void listEmitters(ServerCommand.Context context) {
        Commands.logListOf("Emitters", AdChimneys.getInstance().emitters.getAll(), context);
    }

    public static void showStats(ServerCommand.Context context) {
        WorldData data = WorldData.getData((IWorld)context.getWorld());
        Stats stats = Stats.of(TextFormatting.DARK_AQUA, TextFormatting.YELLOW);
        stats.group("Smoke").value("locations", data.getSmokeLocations().getMap().size());
        Set emitters = AdChimneys.getInstance().emitters.getAll();
        stats.group("Emitters").value("loaded", emitters.size()).value("known", emitters.stream().filter(em -> em.getRelatedId().getFirstMatchedState() != null).mapToInt(e -> 1).sum());
        for (String string : stats.toList()) {
            context.sendMessage(string);
        }
        context.sendMessage("");
    }

    private static Optional<Pair<BlockPos, String>> getTargetBlockInfo(ServerCommand.Context context, boolean showErrorMessages) {
        Optional<BlockRayTraceResult> result = Commands.rayTraceBlockBeingLookedAt(context, showErrorMessages);
        if (result.isPresent()) {
            BlockPos pos = result.get().func_216350_a();
            BlockState state = context.getWorld().func_180495_p(pos);
            return Optional.of(Pair.of((Object)pos, (Object)Commands.coloredUnit("Target block", TextFormatting.GREEN, UnitId.from((BlockState)state))));
        }
        return Optional.empty();
    }

    private static Optional<BlockRayTraceResult> rayTraceBlockBeingLookedAt(ServerCommand.Context context, boolean showErrorMessages) {
        Entity entity = context.getEntity();
        if (entity == null) {
            if (showErrorMessages) {
                context.sendMessage(Commands.coloredError("Sender entity is null"));
            }
            return Optional.empty();
        }
        ArrayList<BlockRayTraceResult> results = new ArrayList<BlockRayTraceResult>();
        for (RayTraceContext.BlockMode blockmod : RayTraceContext.BlockMode.values()) {
            Optional.ofNullable(ForgeEntity.rayTraceBlockBeingLookedAt((Entity)entity, (RayTraceContext.BlockMode)blockmod, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY, (float)1.0f, (float)reachDistance)).ifPresent(results::add);
        }
        results.removeIf(result -> result.func_216346_c() != RayTraceResult.Type.BLOCK);
        double minDistance = Double.MAX_VALUE;
        BlockRayTraceResult closestResult = null;
        for (BlockRayTraceResult result2 : results) {
            double distance = entity.func_174824_e(1.0f).func_72436_e(result2.func_216347_e());
            if (!(distance < minDistance)) continue;
            closestResult = result2;
            minDistance = distance;
        }
        if (closestResult != null) {
            return Optional.of(closestResult);
        }
        if (showErrorMessages) {
            context.sendMessage(Commands.coloredNoInSight("block"));
        }
        return Optional.empty();
    }

    private static String coloredEmitter(String name, IEmitter emitter, boolean active) {
        return name + Commands.coloredText(" is ", TextFormatting.WHITE) + (active ? Commands.coloredText("Active", TextFormatting.RED) : Commands.coloredText("Inactive", TextFormatting.GRAY)) + " " + Commands.coloredText(emitter.toString(), TextFormatting.DARK_AQUA);
    }

    private static String coloredClass(Class<?> clazz, boolean fullName) {
        return Commands.coloredText("Class<" + (fullName ? clazz.getTypeName() : clazz.getSimpleName()) + ">", TextFormatting.DARK_PURPLE);
    }

    private static String coloredNbtTags(INBTSerializable<CompoundNBT> nbtSource) {
        CompoundNBT compound = (CompoundNBT)nbtSource.serializeNBT();
        Predicate name = IEmitter.COMMON_ACTIVE_TAG_NAME;
        ArrayList<String> tags = new ArrayList<String>();
        for (String key : compound.func_150296_c()) {
            ForgeNBT.Types type = ForgeNBT.getType((CompoundNBT)compound, (String)key);
            if (!name.test(key) || !type.isOrdinal() && type != ForgeNBT.Types.STRING) continue;
            tags.add(key);
        }
        return Commands.coloredText("NbtTags: " + ((Object)tags).toString(), TextFormatting.DARK_AQUA);
    }

    private static <O> void logListOf(String title, Collection<O> list, ServerCommand.Context context) {
        Logger logger = AdChimneys.getInstance().getLogger();
        logger.debug(title + "[" + list.size() + "]: {");
        list.forEach(arg_0 -> ((Logger)logger).info(arg_0));
        logger.debug("}");
        context.sendMessage("List of all " + title.toLowerCase() + " was written to .minecraft/logs/debug.log");
    }

    private static String coloredError(String msg) {
        return Commands.coloredText(msg, TextFormatting.RED);
    }

    private static String coloredUnit(String title, TextFormatting color, UnitId id) {
        return Commands.coloredText(title, color) + " -> " + Commands.coloredText(id.toString(), color);
    }

    private static String coloredText(String text, TextFormatting color) {
        return color + text + TextFormatting.RESET;
    }

    private static String coloredNoInSight(String unit) {
        return Commands.coloredText("No " + unit + " in sight", TextFormatting.RED);
    }
}

