/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.blocks.RelatedBlock;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.init.MaterialGroup;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public abstract class Container
extends RelatedBlock
implements ISmokeContainer,
IWaterLoggable {
    private final ColorARGB color;

    public Container(ForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, props.block(props.block.func_200944_c().func_226896_b_()));
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)this.getUnitCategory(), (String)"color", (ColorARGB)props.color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)false);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((IWorld)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return IWaterLoggable.getStateForPlacement((BlockItemUseContext)context, (BlockState)this.func_176223_P());
    }

    public MaterialGroup getMaterialGroup() {
        String blockName = this.getRegistryName().func_110623_a();
        if (blockName.contains("hardened_clay")) {
            return MaterialGroup.TERRACOTTA;
        }
        for (MaterialGroup group : MaterialGroup.values()) {
            if (!blockName.contains(group.getName())) continue;
            return group;
        }
        return MaterialGroup.OTHER;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public boolean isEnabled() {
        if (!this.isChimney() && !this.isOpaqueMaterial(this.func_176223_P())) {
            return false;
        }
        return super.isEnabled() && this.getMaterialGroup().isEnabled();
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean isOpaqueMaterial(BlockState state) {
        return state.func_185904_a().func_76218_k() && state.func_185904_a() != Material.field_151592_s;
    }

    public String toString() {
        return Container.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"color", (Object)this.getColor().getHexARGB()), Args.get((String)"relatedUnitId", (Object)this.getRelatedId())});
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedBlock.Properties<T> {
        public ColorARGB color = ColorARGB.DEFAULT;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> withId(UnitId id) {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)props.id(id);
        }

        public T color(int argb) {
            return this.color(ColorARGB.from((int)argb));
        }

        public T color(ColorARGB color) {
            this.color = color;
            return (T)((Object)((Properties)this.self));
        }
    }
}

