/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.particles.AbstractSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RetroSmokeParticle {
    @OnlyIn(value=Dist.CLIENT)
    public static void generate(World world, IWind wind, Smoke smoke, BlockPos pos, float factor) {
        world.func_217381_Z().func_76320_a("generateRetroSmokeParticles");
        int smokeAmount = Math.round(smoke.getAmount() * factor);
        FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
        FloatBounds dxzBounds = FloatBounds.from((Float)Float.valueOf(0.125f), (Float)Float.valueOf(0.875f)).reduce(Float.valueOf(smoke.getScale() / 10.0f));
        Data data = new Data(wind, smoke);
        for (int i = 0; i < smokeAmount; ++i) {
            double dx = dxzBounds.randomBetween().floatValue();
            double dy = dyBounds.randomBetween().floatValue();
            double dz = dxzBounds.randomBetween().floatValue();
            Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
            world.func_195590_a((IParticleData)data, true, smokePos.x, smokePos.y, smokePos.z, 0.0, 0.0, 0.0);
        }
        world.func_217381_Z().func_76319_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends AbstractSmokeParticle.Instance {
        public Instance(ClientWorld world, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, IAnimatedSprite sprite) {
            super(world, wind, smoke, pos, motion, scale, sprite);
            this.setMotion(this.getMotion().scale((double)0.1f).add(motion));
            this.field_70544_f *= 0.75f * scale;
            this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2));
            this.field_70547_e = (int)((float)this.field_70547_e * scale);
            this.field_70547_e = Math.max(this.field_70547_e, 1);
            this.field_70545_g = -0.004f;
            this.setColor(smoke.pickColor());
        }

        public float func_217561_b(float partialTicks) {
            return this.field_70544_f * MathHelper.func_76131_a((float)(((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e * 32.0f), (float)0.0f, (float)1.0f);
        }

        @Override
        public IParticleRenderType func_217558_b() {
            return IParticleRenderType.field_217602_b;
        }

        @Override
        public void updateAnimatedSprite() {
            this.func_217566_b(this.animatedSprite);
        }

        public void func_217566_b(IAnimatedSprite animatedSprite) {
            int age = this.field_70546_d - this.ticksInChimney;
            int maxAge = this.field_70547_e - this.ticksInChimney;
            this.func_217567_a(animatedSprite.func_217591_a(age, maxAge));
        }

        @Override
        public void func_189213_a() {
            super.func_189213_a();
            this.field_187130_j *= 0.96;
            if (this.inChimney) {
                ++this.field_70546_d;
                if (!this.field_187132_l) {
                    ++this.field_70547_e;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    extends AbstractSmokeParticle.Factory<Data> {
        public Factory(IAnimatedSprite sprite) {
            super(sprite);
        }

        public Particle makeParticle(Data data, ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            double motionY = (double)data.smoke.getIntensity() / 10.0 * CommonMath.Random.between((double)0.5, (double)1.0);
            return new Instance(world, data.wind, data.smoke, Vect3d.from((double)x, (double)y, (double)z), Vect3d.from((double)0.0, (double)motionY, (double)0.0), data.smoke.getScale(), this.sprite);
        }
    }

    public static class Deserializer
    extends AbstractSmokeParticle.Deserializer<Data> {
        public Data deserialize(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }

        public Data read(ParticleType<Data> particleTypeIn, PacketBuffer buffer) {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }
    }

    public static class Data
    extends AbstractSmokeParticle.Data {
        public Data(IWind wind, Smoke smoke) {
            super(wind, smoke);
        }

        public ParticleType<?> func_197554_b() {
            return AdChimneys.getInstance().particles.retro;
        }
    }
}

