/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.events.CampfireSmokeEvent;
import com.endertech.minecraft.forge.events.RandomTickEvent;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.mods.adchimneys.particles.ModernSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.particles.RetroSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Events {
    public static GameTime serverUpdateTime = GameTime.second();
    public static GameTime serverToClientUpdateTime = GameTime.second();
    public static GameTime clientUpdateTime = GameTime.quaterSecond();
    public static GameTime clientWaitForUpdateTime = GameTime.seconds((int)2);

    @SubscribeEvent
    public static void onRandomTick(RandomTickEvent.Block event) {
    }

    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        IWorld world = event.getWorld();
        if (GameWorld.isServerSide((IWorldReader)world)) {
            WorldData.getData(world).updateSmokeEmitterAt(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        IWorld world = event.getWorld();
        if (world != null && GameWorld.isServerSide((IWorldReader)world)) {
            WorldData data = WorldData.getData(world);
            Set positions = event.getChunk().func_203066_o();
            positions.forEach(pos -> data.getSmokeLocations().add((BlockPos)pos, Smoke.getNone()));
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && serverUpdateTime.pastIn(world)) {
            WorldData data = WorldData.getData((IWorld)world);
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = data.getSmokeLocations().getEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos pos = entry.getKey();
                Smoke smoke = entry.getValue();
                if (!smoke.getLifeTime().moreThan(serverToClientUpdateTime.getInterval())) continue;
                data.updateSmokeEmitterAt(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        World world = event.player.func_130014_f_();
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT && clientUpdateTime.pastIn(world)) {
            WorldData data = WorldData.getData((IWorld)world);
            SmokeLocations locations = data.getSmokeLocations();
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = locations.getEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos pos = entry.getKey();
                Smoke smoke = entry.getValue();
                double distance = ForgeEntity.getCurPosition((Entity)Minecraft.func_71410_x().func_175606_aa()).distance(Vect3d.from((BlockPos)pos));
                float totalParticlesAmount = locations.getTotalParticlesAmount();
                if (totalParticlesAmount > 0.0f && smoke.hasParticles() && smoke.getLifeTime().lessThan(clientWaitForUpdateTime.getInterval()) && distance <= (double)((Integer)Smoke.maxRenderDistance.get()).intValue() && (((Boolean)Smoke.emitWithoutChimney.get()).booleanValue() || GameWorld.SmokeContainers.isChimney((IWorldReader)world, (BlockPos)pos))) {
                    float emittionFactor = locations.getParticlesReductionFactor();
                    float renderFactor = data.getParticlesReductionFactor();
                    IWind wind = GameWorld.getWindAt((World)world, (BlockPos)pos);
                    float factor = Math.min(emittionFactor, renderFactor);
                    if (((Boolean)Smoke.retroParticles.get()).booleanValue()) {
                        RetroSmokeParticle.generate(world, wind, smoke, pos, factor);
                        continue;
                    }
                    ModernSmokeParticle.generate(world, wind, smoke, pos, factor);
                    continue;
                }
                locations.remove(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (GameWorld.isServerSide((IWorldReader)world)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        IWorld world = event.getWorld();
        WorldData.DATA_MAP.remove(world);
    }

    @SubscribeEvent
    public static void onCampfireSmokeSpawn(CampfireSmokeEvent event) {
        if (((Boolean)Smoke.disableVanillaCampfireSmoke.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }
}

