/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.Events;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class WorldData {
    static final Map<IWorld, WorldData> DATA_MAP = new ConcurrentHashMap<IWorld, WorldData>();
    final SmokeLocations smokeLocations = new SmokeLocations();
    final IWorld world;

    public WorldData(IWorld world) {
        this.world = world;
    }

    @Nonnull
    public static WorldData getData(IWorld world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            DATA_MAP.put(world, data);
        }
        return data;
    }

    public float getParticlesReductionFactor() {
        float factor = 1.0f;
        int particlesCount = GameWorld.getData((IWorld)this.getWorld()).smokeParticlesCount;
        if (particlesCount > (Integer)Smoke.maxRenderedParticlesAmount.get()) {
            factor = (float)((Integer)Smoke.maxRenderedParticlesAmount.get()).intValue() / (float)particlesCount;
        }
        return factor;
    }

    public void updateSmokeEmitterAt(BlockPos emitterPos) {
        if (GameWorld.isClientSide((IWorldReader)this.world)) {
            return;
        }
        if (emitterPos instanceof BlockPos.Mutable) {
            return;
        }
        if (!GameWorld.isBlockLoaded((IWorldReader)this.world, (BlockPos)emitterPos)) {
            this.getSmokeLocations().remove(emitterPos);
            return;
        }
        Emitter emitter = AdChimneys.getInstance().emitters.findBy((IWorldReader)this.world, emitterPos);
        Smoke emitterSmoke = this.getSmokeLocations().get(emitterPos);
        if (emitter != null) {
            if (emitterSmoke == null || emitterSmoke.getLifeTime().moreThan(Events.serverToClientUpdateTime.getInterval())) {
                Smoke outletSmoke;
                int count;
                emitterSmoke = emitter.getSmoke((IWorldReader)this.world, emitterPos, true, true);
                ArrayList<BlockPos> outlets = new ArrayList<BlockPos>();
                int maxOutletsAmount = (int)emitterSmoke.getAmount();
                WorldSearch.VentPipe.PumpFunc addOutlets = (worldIn, posIn, maxAmount) -> {
                    outlets.add(posIn);
                    return 1;
                };
                Predicate<BlockPos> impassablePipe = pos -> !this.isPassablePipe((BlockPos)pos);
                WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((IWorld)this.world, (BlockPos)emitterPos, (Set)emitter.getRelatedBlocks());
                boolean anyChimneyConnected = false;
                List activeVents = neighbors.getActiveVents();
                if (!activeVents.isEmpty()) {
                    count = WorldSearch.VentPipe.pump((IWorld)this.world, (List)activeVents, (int)maxOutletsAmount, GameWorld.SmokeContainers::isChimney, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                    if (count > 0) {
                        anyChimneyConnected = true;
                    }
                    outlets.removeIf(impassablePipe);
                    if (outlets.isEmpty()) {
                        WorldSearch.VentPipe.pump((IWorld)this.world, (List)activeVents, (int)maxOutletsAmount, (w, pos) -> this.isPassablePipe(pos), (WorldSearch.VentPipe.PumpFunc)addOutlets);
                    }
                }
                if (outlets.isEmpty()) {
                    List<BlockPos> topChimneys = WorldData.getTopChimneys(neighbors, emitter.getMaxGapLength());
                    if (!topChimneys.isEmpty()) {
                        anyChimneyConnected = true;
                    }
                    topChimneys.removeIf(impassablePipe);
                    outlets.addAll(topChimneys);
                }
                if (emitter.canEmitAside()) {
                    List sideChimneys = neighbors.getSideChimneys();
                    if (!sideChimneys.isEmpty()) {
                        anyChimneyConnected = true;
                    }
                    sideChimneys.removeIf(impassablePipe);
                    outlets.addAll(sideChimneys);
                    if (outlets.isEmpty()) {
                        count = WorldSearch.VentPipe.pump((IWorld)this.world, (List)neighbors.getPassiveVents(), (int)maxOutletsAmount, GameWorld.SmokeContainers::isChimney, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                        if (count > 0) {
                            anyChimneyConnected = true;
                        }
                        outlets.removeIf(impassablePipe);
                    }
                }
                if (outlets.isEmpty() && (anyChimneyConnected || emitter.emitWithoutChimney())) {
                    for (BlockPos pos2 : neighbors.getAboveBlocks()) {
                        if (!this.isPassablePipe(pos2)) continue;
                        outlets.add(pos2);
                    }
                    if (outlets.isEmpty()) {
                        outlets.add(emitterPos);
                    }
                }
                int outletsCount = Math.min(outlets.size(), maxOutletsAmount);
                this.getSmokeLocations().add(emitterPos, emitterSmoke);
                if (outletsCount > 0 && (outletSmoke = emitterSmoke.devideInto(outletsCount)).hasParticles()) {
                    int count2 = 1;
                    for (BlockPos pos3 : outlets) {
                        if (count2 <= outletsCount) {
                            if (this.world instanceof IServerWorld) {
                                new SmokePosMsg(pos3, outletSmoke).sendToAllAround((IServerWorld)this.world, pos3, (Integer)Smoke.maxRenderDistance.get());
                            }
                            ++count2;
                            continue;
                        }
                        break;
                    }
                }
            }
        } else if (emitterSmoke != null) {
            this.getSmokeLocations().remove(emitterPos);
        }
    }

    protected boolean isPassablePipe(BlockPos startPos) {
        if (GameWorld.SmokeContainers.isChimney((IWorldReader)this.world, (BlockPos)startPos)) {
            startPos = GameWorld.SmokeContainers.getTopmostChimney((IWorldReader)this.world, (BlockPos)startPos).func_177984_a();
        }
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !Smoke.canPassThrough((IBlockReader)this.world, startPos, Direction.DOWN, direction) || !Smoke.canPassThrough((IBlockReader)this.world, startPos.func_177972_a(direction), direction.func_176734_d(), Direction.UP)) continue;
            return true;
        }
        return false;
    }

    protected static List<BlockPos> getTopChimneys(WorldSearch.TileNeighbors neighbors, int maxGapLength) {
        IWorld world = neighbors.getWorld();
        ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
        block0: for (BlockPos startPos : neighbors.getAboveBlocks()) {
            for (int i = 0; i <= maxGapLength; ++i) {
                BlockPos pos = startPos.func_177981_b(i);
                if (GameWorld.SmokeContainers.isChimney((IWorldReader)world, (BlockPos)pos)) {
                    chimneys.add(pos);
                    continue block0;
                }
                if (!GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) continue block0;
            }
        }
        return chimneys;
    }

    public IWorld getWorld() {
        return this.world;
    }

    public SmokeLocations getSmokeLocations() {
        return this.smokeLocations;
    }
}

