/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.AbstractGenerator;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaOre;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class VanillaController
extends AbstractGenerator {
    public static ForgeConfigSpec.ConfigValue<Boolean> disableLargeVeins;
    private final AbstractForgeMod mod;
    private Optional<VanillaOres> ores = Optional.empty();

    public VanillaController(AbstractForgeMod mod) {
        super(mod, "vanilla_controller");
        this.mod = mod;
    }

    public void loadOres() {
        this.ores = Optional.of(new VanillaOres(this.mod));
        this.ores.get().onPostInit();
    }

    public void unloadOres() {
        this.ores = Optional.empty();
    }

    public boolean generateAt(WorldGenLevel level, ChunkPos chunk, Random random) {
        if (this.ores.isEmpty()) {
            return false;
        }
        List passed = this.ores.get().getAll().stream().map(Supplier::get).filter(ore -> ore.getGeneration() == VanillaOre.Generation.CUSTOM && ore.inAllowedDimenstion((ServerLevelAccessor)level) && ore.isValid()).collect(Collectors.toList());
        Collections.shuffle(passed, random);
        int count = 0;
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunk);
        for (VanillaOre ore2 : passed) {
            int maxVeins = ore2.getVeinsInChunk().randomBetween(random);
            for (int i = 0; i < maxVeins; ++i) {
                BlockPos pos = new BlockPos(chunkBounds.getX().randomBetween(random).intValue(), ore2.getAltitude().randomBetween(random).intValue(), chunkBounds.getZ().randomBetween(random).intValue());
                int amount = ore2.getBlocksInVein().randomBetween(random);
                count += ore2.generate(level, pos, amount, false, random);
            }
        }
        return count > 0;
    }

    public void doAdditions(BiomeLoadingEvent biome) {
        if (this.ores.isEmpty()) {
            this.loadOres();
        }
        if (this.ores.get().streamAll().anyMatch(ore -> ore.getGeneration() == VanillaOre.Generation.CUSTOM)) {
            biome.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(this.placedFeature);
        }
    }

    public void doRemovals(BiomeLoadingEvent biome) {
        if (this.ores.isEmpty()) {
            this.loadOres();
        }
        for (GenerationStep.Decoration stage : new GenerationStep.Decoration[]{GenerationStep.Decoration.UNDERGROUND_ORES, GenerationStep.Decoration.UNDERGROUND_DECORATION}) {
            List features = biome.getGeneration().getFeatures(stage);
            this.ores.get().streamAll().filter(ore -> ore.getGeneration() != VanillaOre.Generation.VANILLA).forEach(ore -> features.removeIf(ore::matches));
        }
    }

    public void doOther(BiomeLoadingEvent biome) {
    }

    static class VanillaOres
    extends RelatedUnitsInit<VanillaOre, BuiltIn> {
        public VanillaOres(AbstractForgeMod mod) {
            super(mod, BuiltIn.class);
        }

        public Supplier<VanillaOre> createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
            return () -> new VanillaOre(config, e.props);
        }

        public Supplier<VanillaOre> createCustomUnitFrom(UnitConfig config, String name) {
            UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
            return () -> new VanillaOre(config, (VanillaOre.Properties)VanillaOre.Properties.overworld().id(id));
        }

        static enum BuiltIn implements IForgeEnum
        {
            DIRT((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(7))).altitude(0, 160))),
            GRAVEL((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(14))).altitude(-64, 319))),
            GRANITE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(8))).altitude(0, 128))),
            DIORITE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(8))).altitude(0, 128))),
            ANDESITE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(8))).altitude(0, 128))),
            TUFF((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(64))).veins(2))).altitude(-64, 0))),
            CLAY((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(46))).altitude(-64, 256))),
            INFESTED_STONE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("infested_deepslate"))).size(9))).veins(14))).altitude(-64, 63))),
            COAL_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("coal_ore"))).size(17))).veins(50))).altitude(0, 319))),
            COPPER_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("copper_ore"))).size(15))).veins(16))).altitude(-16, 112))),
            IRON_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("iron_ore"))).size(9))).veins(110))).altitude(-64, 384))),
            REDSTONE_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("redstone_ore"))).size(8))).veins(8))).altitude(-32, 16))),
            LAPIS_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("lapis_ore"))).size(7))).veins(6))).altitude(-32, 64))),
            GOLD_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("gold_ore"))).size(9))).veins(8))).altitude(-64, 32))),
            DIAMOND_ORE((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("diamond_ore"))).size(8))).veins(8))).altitude(-64, 16))).exposed(false))),
            EMERALD_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().deepslate("emerald_ore"))).size(3))).veins(100))).altitude(-16, 480))),
            MAGMA_BLOCK((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(33))).veins(4))).altitude(27, 36))),
            NETHER_QUARTZ_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(14))).veins(16))).altitude(10, 117))),
            NETHER_GOLD_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(10))).veins(10))).altitude(10, 117))),
            ANCIENT_DEBRIS((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(3))).veins(2))).altitude(8, 119))).exposed(false))),
            SOUL_SAND((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(12))).veins(12))).altitude(1, 31))),
            BLACKSTONE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(33))).veins(2))).altitude(5, 31)));

            final VanillaOre.Properties<?> props;

            private BuiltIn(VanillaOre.Properties<?> props) {
                this.props = (VanillaOre.Properties)props.emptyToEnumId(this, false);
            }
        }
    }
}

