/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Stripper {
    protected static final Map<Level, Stripper> strippers = new ConcurrentHashMap<Level, Stripper>();
    protected final Map<ChunkPos, BlockState[][][]> strippedChunks = new ConcurrentHashMap<ChunkPos, BlockState[][][]>();

    public static Stripper getFor(Level world) {
        Stripper stripper = strippers.get(world);
        if (stripper == null) {
            stripper = new Stripper();
            strippers.put(world, stripper);
        }
        return stripper;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        strippers.remove(event.getWorld());
    }

    public void stripChunk(Level level, ChunkPos chunkPos, BiPredicate<Level, BlockPos> isOreBlock) {
        if (this.strippedChunks.containsKey(chunkPos)) {
            return;
        }
        ChunkBounds bounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
        BlockState[][][] data = new BlockState[16][bounds.getHeight()][16];
        int bottomLayer = bounds.getY().getMin();
        bounds.forEach(pos -> {
            BlockState state;
            BlockPos rel = bounds.relative((BlockPos)pos);
            if (level.m_46859_((BlockPos)pos) || isOreBlock.test(level, (BlockPos)pos) || level.m_7702_((BlockPos)pos) != null) {
                return;
            }
            data[rel.m_123341_()][rel.m_123342_()][rel.m_123343_()] = state = level.m_8055_((BlockPos)pos);
            if (pos.m_123342_() != bottomLayer) {
                level.m_7731_((BlockPos)pos, Blocks.f_50016_.m_49966_(), 50);
            }
        });
        this.strippedChunks.put(chunkPos, data);
    }

    public void stripChunksAround(Level world, ChunkPos centerPos, BiPredicate<Level, BlockPos> isOreBlock) {
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.stripChunk(world, chunkPos, isOreBlock);
        }
    }

    public void dressChunk(Level world, ChunkPos chunkPos) {
        this.dressChunk(world, chunkPos, true);
    }

    public void dressChunksAround(Level world, ChunkPos centerPos) {
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.dressChunk(world, chunkPos);
        }
    }

    public void dressAllChunks(Level world) {
        for (ChunkPos chunkPos : this.strippedChunks.keySet()) {
            this.dressChunk(world, chunkPos, false);
        }
        this.strippedChunks.clear();
    }

    protected void dressChunk(Level level, ChunkPos chunkPos, boolean removeEntry) {
        if (!this.strippedChunks.containsKey(chunkPos)) {
            return;
        }
        BlockState[][][] data = this.strippedChunks.get(chunkPos);
        ChunkBounds bounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
        bounds.forEach(pos -> {
            BlockPos rel = bounds.relative((BlockPos)pos);
            BlockState state = data[rel.m_123341_()][rel.m_123342_()][rel.m_123343_()];
            if (state != null) {
                level.m_7731_((BlockPos)pos, state, 2);
            }
        });
        if (removeEntry) {
            this.strippedChunks.remove(chunkPos);
        }
    }
}

