/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.Indicator;
import com.endertech.minecraft.mods.adlods.ore.OreChain;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class Deposit
extends AbstractOre {
    public static ForgeConfigSpec.ConfigValue<Double> globalSizeMultiplier;
    public static ForgeConfigSpec.ConfigValue<Double> globalSpawnRateMultiplier;
    protected final boolean enabled;
    protected final String name;
    protected final IntBounds size;
    protected final int rarity;
    protected final CommonCollect.WeightedList<WeightedOre> ores;
    protected final Percentage chance;
    protected final Indicator indicator;

    public Deposit(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.name = props.name;
        this.enabled = UnitConfig.readConfigEnabled((UnitConfig)config, (boolean)true);
        this.size = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Size", (IntBounds)props.size, (IntBounds)Size.BOUNDS, (String)"Size limits (in blocks) of this deposit.");
        this.rarity = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"rarity", (int)props.rarity, (IntBounds)Rarity.BOUNDS, (String)"Rarity (in chunks) of this deposit.\nHigher values give more rare deposit spawning.\nExample: value of 1000, means that 1 deposit can be spawned per 1000 chunks,\n that gives us 1 / 1000 * 100% = 0.1% chance of spawing per chunk.");
        this.chance = Percentage.value((float)(Percentage.from((int)1, (int)this.rarity).getValue() * ((Double)globalSpawnRateMultiplier.get()).floatValue()));
        this.indicator = new Indicator(config, category, props.indicators);
        this.ores = Deposit.parseOresFrom(UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"ores", (String[])props.ores, (String)"List of ores and their weights for this deposit.\nSyntax: oreId [, weight]\n\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n\nWeight is used to define the proportions of the ores. For example, the definition:\n     #forge:ores/gold, 1\n     #forge:ores/iron, 5\n means that gold and iron will be in the proportion 1 to 5."), state -> this.dimensions.isAllowed((Object)Dimensions.THE_NETHER.dimensionId) || !ForgeBlock.getRegistryName((Block)state.m_60734_()).m_135815_().contains("nether"));
        this.saveConfig();
    }

    public static Deposit in(Path dir, Properties<?> props) {
        return new Deposit(UnitConfig.in((Path)dir, (String)props.name), props);
    }

    public static CommonCollect.WeightedList<WeightedOre> parseOresFrom(String[] array, Predicate<BlockState> filter) {
        CommonCollect.WeightedList ores = new CommonCollect.WeightedList();
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            String[] split = str.split(",");
            UnitId id = UnitId.from((String)split[0].trim());
            int proportion = 1;
            boolean error = id.isEmpty();
            if (split.length > 1) {
                try {
                    proportion = Integer.parseInt(split[1].trim());
                    if (proportion <= 0) {
                        error = true;
                    }
                }
                catch (Exception e) {
                    error = true;
                }
            }
            if (!error) {
                BlockState state = Optional.ofNullable(id.getFirstMatchedState()).filter(filter).or(() -> Optional.ofNullable(id.getAllMatchedBlockStates()).flatMap(set -> set.getBlocksWithAllStates().stream().map(Block::m_49966_).filter(filter).findFirst().or(() -> set.stream().filter(filter).findFirst()))).orElse(null);
                if (state == null) continue;
                ores.add((CommonCollect.IWeighted)new WeightedOre(state, proportion));
                continue;
            }
            AdLods.getInstance().getLogger().error("Unable to parse ore from " + CommonString.quoted((String)str));
        }
        return ores;
    }

    public DepositGenResult generateAt(WorldGenLevel level, ChunkPos chunkPos) {
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
        return this.generateAt(level, chunkBounds.getX().randomBetween(), chunkBounds.getZ().randomBetween());
    }

    public DepositGenResult generateAt(WorldGenLevel level, int posX, int posZ) {
        BlockPos startPos = new BlockPos(posX, this.altitude.randomBetween().intValue(), posZ);
        float factor = ((Double)globalSizeMultiplier.get()).floatValue();
        int amount = Math.round((float)this.size.randomBetween().intValue() * factor);
        int minSize = Math.round((float)this.size.getMin().intValue() * factor);
        DepositGenResult result = this.generateAt(level, startPos, amount, false);
        if (result.size >= minSize) {
            this.indicator.placeFor(level, result);
        }
        return result;
    }

    public DepositGenResult generateAt(WorldGenLevel level, BlockPos startPos, int amount, boolean testing) {
        if (!testing && !this.inAllowedDimenstion((ServerLevelAccessor)level)) {
            ForgeEndertech.debugMsg((String)("Not in allowable dimension for " + this.getName() + " deposit"));
            return new DepositGenResult(this.getName(), startPos, 0);
        }
        int count = this.generate(level, startPos, amount, testing);
        DepositGenResult result = new DepositGenResult(this.getName(), startPos, count);
        ServerLevel serverLevel = level.m_6018_();
        WorldData.getData((LevelAccessor)serverLevel).addDepositGenResult(result);
        ForgeEndertech.debugMsg((String)result.toString());
        return result;
    }

    @Override
    protected int generate(final WorldGenLevel level, BlockPos startPos, int amount, final boolean testing) {
        return new OreChain((LevelAccessor)level, startPos, amount, this.miscellaneous){

            @Override
            public boolean replaceWithOre(BlockPos pos) {
                return Deposit.this.replaceWithOre(this.world, pos);
            }

            protected boolean isValidPath(BlockPos pos) {
                return Deposit.this.isValidPosition(level, pos, this.startPos, testing) && Deposit.this.isOreBlock(this.world, pos);
            }

            protected boolean isValidBlock(BlockPos pos) {
                return Deposit.this.isValidPosition(level, pos, this.startPos, testing) && Deposit.this.canBeReplaced(this.world, pos, testing);
            }
        }.generate().getCount();
    }

    protected BlockStatesSet getReplaceableBlocks() {
        return this.replaceableBlocks;
    }

    @Override
    protected boolean replaceWithOre(LevelAccessor level, BlockPos pos) {
        BlockState state = null;
        if (!this.customReplacements.isEmpty()) {
            state = (BlockState)this.customReplacements.get((Object)level.m_8055_(pos));
        }
        if (state == null) {
            state = this.ores.getRandom(() -> ((RandomSource)level.m_213780_()).m_188500_()).map(WeightedOre::getBlockState).orElse(null);
        }
        if (state != null) {
            return level.m_7731_(pos, state, 18);
        }
        return false;
    }

    public boolean isOreBlock(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (this.customReplacements.containsValue((Object)state)) {
            return true;
        }
        for (WeightedOre ore : this.ores.getElements()) {
            if (!ore.getBlockState().equals(state)) continue;
            return true;
        }
        return GameWorld.isOreBlock((LevelReader)level, (BlockPos)pos, (BlockState)state);
    }

    @Override
    public boolean isValid() {
        return this.enabled && !this.name.isEmpty() && !this.ores.isEmpty() && !this.replaceableBlocks.isEmpty() && CommonMath.notZero((double)this.getChance().getValue()) && this.size.getMin() > 0;
    }

    public Percentage getChance() {
        return this.chance;
    }

    public String getName() {
        return this.name;
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractOre.Properties<T> {
        public final String name;
        public IntBounds size = IntBounds.ZERO;
        public int rarity = 0;
        public String[] ores = new String[0];
        public String[] indicators = new String[0];

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass);
            this.name = name;
        }

        public static Properties<?> overworld(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> nether(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
        }

        public T size(int min, int max) {
            this.size = IntBounds.between((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T rarity(int rarity) {
            this.rarity = rarity;
            return (T)((Object)((Properties)this.self));
        }

        public T ores(String ... ores) {
            this.ores = ores;
            return (T)((Object)((Properties)this.self));
        }

        public T indicators(String ... indicators) {
            this.indicators = indicators;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Size
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.between((Integer)1, (Integer)32000);
        public static final Size ZERO = new Size(0, 0);

        public static Size from(IntBounds bounds) {
            return new Size(bounds.getMin(), bounds.getMax());
        }

        public Size(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Rarity
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.between((Integer)1, (Integer)256000);

        public Rarity(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Altitude
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.INTEGER;
        public static final Altitude ZERO = new Altitude(0, 0);

        public static Altitude from(IntBounds bounds) {
            return new Altitude(bounds.getMin(), bounds.getMax());
        }

        public Altitude(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }
}

