/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonPath;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import java.nio.file.Path;

public abstract class UnitsInitWithEnum<U, E extends Enum<?>>
extends UnitsInit<U> {
    protected final Class<E> builtInEnum;

    public UnitsInitWithEnum(AbstractForgeMod mod, Class<E> builtInEnum) {
        super(mod);
        this.builtInEnum = builtInEnum;
        this.initDefaultConfigs();
        this.initCustomConfigs();
    }

    protected void initDefaultConfigs() {
        for (Enum enumValue : (Enum[])this.builtInEnum.getEnumConstants()) {
            String name = ((IForgeEnum)((Object)enumValue)).getName();
            UnitConfig config = UnitConfig.in(this.getConfigsDir(), name);
            this.addUnit(name, () -> this.createDefaultUnitFrom(config, enumValue));
            config.save();
        }
    }

    protected void initCustomConfigs() {
        for (Path path : UnitConfig.listCustomConfigs(this.getConfigsDir(), this.builtInEnum)) {
            UnitConfig config = new UnitConfig(path.toFile());
            String name = CommonPath.getFileNameOnly(path);
            this.addUnit(name, () -> this.createCustomUnitFrom(config, name));
            config.save();
        }
    }

    public void reloadConfigs() {
        this.removeAll();
        this.initDefaultConfigs();
        this.initCustomConfigs();
        this.onPostInit();
    }

    public abstract U createDefaultUnitFrom(UnitConfig var1, E var2);

    public abstract U createCustomUnitFrom(UnitConfig var1, String var2);
}

