/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitProperties;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeBlock
extends Block
implements IHaveConfig {
    public static final AABB FULL_BLOCK_AABB = Shapes.m_83144_().m_83215_();
    @Nullable
    private final UnitConfig config;

    public ForgeBlock(@Nullable UnitConfig config, Properties<?> props) {
        this(config, props.vanillaProps);
    }

    public ForgeBlock(@Nullable UnitConfig config, BlockBehaviour.Properties props) {
        super(props);
        this.config = config;
    }

    public static ResourceLocation getRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public static boolean isUnderRain(Level world, BlockPos pos) {
        return world.m_46758_(pos.m_7494_());
    }

    public static boolean isUnderOpenSky(Level world, BlockPos pos) {
        return world.m_45527_(pos.m_7494_());
    }

    @Override
    @Nullable
    public UnitConfig getConfig() {
        return this.config;
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public final Material material;
        public final BlockBehaviour.Properties vanillaProps;

        public static Properties<?> of(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name);
            this.material = material;
            this.vanillaProps = BlockBehaviour.Properties.m_60939_((Material)material);
        }

        public T randomTicks() {
            this.vanillaProps.m_60977_();
            return (T)((Properties)this.self);
        }

        public T noOcclusion() {
            this.vanillaProps.m_60955_();
            return (T)((Properties)this.self);
        }
    }
}

