/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenerator;
import com.endertech.minecraft.mods.adlods.world.Stripper;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.StringJoiner;
import net.minecraft.Util;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public final class Commands {
    public static ServerCommand.Arg<String> depositArgument() {
        return ServerCommand.Arg.word((String)"deposit", (context, builder) -> SharedSuggestionProvider.m_82981_(((DepositGenerator)((Object)((Object)AdLods.getInstance().features.generator.get()))).getDeposits().stream().map(Deposit::getName), (SuggestionsBuilder)builder));
    }

    public static void listDeposits(ServerCommand.Context context) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Deposit deposit : ((DepositGenerator)((Object)AdLods.getInstance().features.generator.get())).getDeposits()) {
            joiner.add(deposit.getName());
        }
        context.sendMessage(joiner.toString());
    }

    public static void listGenerated(ServerCommand.Context context) {
        Logger logger = AdLods.getInstance().getLogger();
        Collection<DepositGenResult> deposits = WorldData.getData((LevelAccessor)context.getLevel()).getGeneratedDeposits().values();
        if (deposits.isEmpty()) {
            context.sendMessage("No data on generated deposits are available");
        } else {
            logger.info("Deposits: {");
            deposits.forEach(data -> logger.info("\t" + data));
            logger.info("}");
            context.sendMessage("List of generated deposits (" + deposits.size() + ") was written to .minecraft/logs/latest.log");
        }
    }

    public static void locateConfigs(ServerCommand.Context context) {
        Util.m_137581_().m_137644_(AdLods.getInstance().getConfigsDir().toFile());
    }

    public static void addDeposit(ServerCommand.Context context, boolean isOreIdSpecified) {
        String name;
        DepositGenerator generator = (DepositGenerator)((Object)AdLods.getInstance().features.generator.get());
        Path baseDir = generator.getConfigsDir();
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)(name = Commands.getDepositName(context))).toFile();
        if (configFile.isFile()) {
            context.sendMessage("Config file <" + configFile.getName() + "> already exists!");
            return;
        }
        Deposit deposit = generator.findDepositBy(name).orElse(null);
        if (deposit != null) {
            String fileName = deposit.getConfig().getConfigFile().getName();
            context.sendMessage("Deposit with this name already defined in: " + fileName);
            return;
        }
        int rarity = (Integer)context.getArgument("rarity", Integer.TYPE);
        Deposit.Size size = Deposit.Size.from((IntBounds)context.getArgument("size", IntBounds.class));
        Deposit.Altitude altitude = Deposit.Altitude.from((IntBounds)context.getArgument("altitude", IntBounds.class));
        Deposit deposit2 = isOreIdSpecified ? generator.createCustomDeposit(baseDir, name, size, altitude, rarity, new String[]{UnitId.from((BlockState)((BlockInput)context.getArgument("oreId", BlockInput.class)).m_114669_()).toString()}, new String[0]) : generator.createCustomDeposit(baseDir, name, size, altitude, rarity, new String[0]);
        context.sendMessage("Deposit config created");
        if (!deposit2.isValid()) {
            context.sendMessage("Deposit is not valid! Check its parameters");
        }
        if (generator.addDeposit(deposit2)) {
            context.sendMessage("Deposit definition successfully added");
        }
    }

    public static void removeDeposit(ServerCommand.Context context) {
        DepositGenerator generator = (DepositGenerator)((Object)AdLods.getInstance().features.generator.get());
        Path baseDir = generator.getConfigsDir();
        String name = Commands.getDepositName(context);
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)name).toFile();
        Deposit deposit = generator.findDepositBy(name).orElse(null);
        if (deposit != null) {
            if (generator.removeDeposit(deposit)) {
                context.sendMessage("Deposit definition removed");
            }
            configFile = deposit.getConfig().getConfigFile();
        }
        if (configFile.delete()) {
            context.sendMessage("Deposit config removed");
        }
    }

    public static void generateDeposit(ServerCommand.Context context) {
        BlockPos startPos = context.getBlockPos();
        Commands.generateDepositAt(context, startPos.m_123341_(), startPos.m_123343_());
    }

    public static void generateDepositAtPos(ServerCommand.Context context) {
        int x = (Integer)context.getArgument("posX", Integer.TYPE);
        int z = (Integer)context.getArgument("posZ", Integer.TYPE);
        Commands.generateDepositAt(context, x, z);
    }

    public static void generateDepositAtChunk(ServerCommand.Context context) {
        int x = (Integer)context.getArgument("chunkX", Integer.TYPE);
        int z = (Integer)context.getArgument("chunkZ", Integer.TYPE);
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)context.getLevel(), (ChunkPos)new ChunkPos(x, z));
        Commands.generateDepositAt(context, chunkBounds.getX().randomBetween(), chunkBounds.getZ().randomBetween());
    }

    static void generateDepositAt(ServerCommand.Context context, int posX, int posZ) {
        String name = Commands.getDepositName(context);
        Deposit deposit = ((DepositGenerator)((Object)AdLods.getInstance().features.generator.get())).findDepositBy(name).orElse(null);
        if (deposit != null) {
            if (context.getLevel().m_46749_(new BlockPos(posX, 0, posZ))) {
                DepositGenResult result = deposit.generateAt((WorldGenLevel)context.getLevel(), posX, posZ);
                context.sendMessage(result.toString());
            } else {
                context.sendMessage(BlockPosArgument.f_118234_.toString());
            }
        } else {
            context.sendMessage(Commands.depositNotFoundMsg(name));
        }
    }

    public static void testDeposit(ServerCommand.Context context) {
        String name = Commands.getDepositName(context);
        Deposit deposit = ((DepositGenerator)((Object)AdLods.getInstance().features.generator.get())).findDepositBy(name).orElse(null);
        if (deposit != null) {
            BlockPos startPos = context.getBlockPos();
            int amount = (Integer)context.getArgument("amount", Integer.TYPE);
            DepositGenResult result = deposit.generateAt((WorldGenLevel)context.getLevel(), startPos, amount, true);
            context.sendMessage(result.toString());
        } else {
            context.sendMessage(Commands.depositNotFoundMsg(name));
        }
    }

    public static void reloadConfigs(ServerCommand.Context context) {
        AdLods.getInstance().features.reload();
        context.sendMessage("Configs reloaded");
    }

    public static void stripChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((Level)context.getLevel());
        stripper.stripChunk((Level)context.getLevel(), centerPos, ((DepositGenerator)((Object)AdLods.getInstance().features.generator.get()))::isOreBlock);
        context.sendMessage("Chunk at " + centerPos + " stripped");
    }

    public static void stripChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((Level)context.getLevel());
        stripper.stripChunksAround((Level)context.getLevel(), centerPos, ((DepositGenerator)((Object)AdLods.getInstance().features.generator.get()))::isOreBlock);
        context.sendMessage("Chunks around " + centerPos + " stripped");
    }

    public static void dressChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((Level)context.getLevel());
        stripper.dressChunk((Level)context.getLevel(), centerPos);
        context.sendMessage("Chunk at " + centerPos + " dressed");
    }

    public static void dressChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((Level)context.getLevel());
        stripper.dressChunksAround((Level)context.getLevel(), centerPos);
        context.sendMessage("Chunks around " + centerPos + " dressed");
    }

    public static void dressAllChunks(ServerCommand.Context context) {
        Stripper stripper = Stripper.getFor((Level)context.getLevel());
        stripper.dressAllChunks((Level)context.getLevel());
        context.sendMessage("All stripped chunks dressed");
    }

    static String getDepositName(ServerCommand.Context context) {
        return ((String)context.getArgument("deposit", String.class)).toLowerCase(Locale.ROOT);
    }

    static String depositNotFoundMsg(String name) {
        return "Deposit with name " + CommonString.quoted((String)name) + " not found! Use </lods list> command.";
    }
}

