/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.network.TileSharedDataMsg;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ForgeTile
extends BlockEntity {
    public static <T extends BlockEntity> BlockEntityType.Builder<T> builder(BlockEntityType.BlockEntitySupplier<? extends T> factory, Collection<? extends Block> validBlocks) {
        return ForgeTile.builder(factory, validBlocks.toArray(new Block[0]));
    }

    public static <T extends BlockEntity> BlockEntityType.Builder<T> builder(BlockEntityType.BlockEntitySupplier<? extends T> factory, Block ... validBlocks) {
        return BlockEntityType.Builder.m_155273_(factory, (Block[])validBlocks);
    }

    public static Optional<ResourceLocation> getRegistryName(BlockEntity tile) {
        return Optional.ofNullable(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tile.m_58903_()));
    }

    public ForgeTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag compound = this.writeSharedData(new CompoundTag());
        return compound.m_128456_() ? null : ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> compound);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readSharedData(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readSharedData(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSharedData(compound);
    }

    public CompoundTag getSharedData() {
        return this.writeSharedData(new CompoundTag());
    }

    public void syncWithClients() {
        Level world = this.m_58904_();
        if (world != null && GameWorld.isServerSide((LevelReader)world)) {
            TileSharedDataMsg message = new TileSharedDataMsg(this.getSharedData(), this.m_58899_());
            ForgeEndertech.getInstance().getConnection().sendToAllObservingChunk(message, world.m_46745_(this.m_58899_()));
            this.m_6596_();
        }
    }

    public abstract void readSharedData(CompoundTag var1);

    public abstract CompoundTag writeSharedData(CompoundTag var1);
}

