/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.BaseProperties;
import com.endertech.minecraft.forge.data.Names;

public class Miscellaneous {
    public final boolean exposed;
    public final float proportions;
    public final boolean strictBounds;

    public static Miscellaneous of(UnitConfig config, String category, Properties<?> props) {
        return new Miscellaneous(config, category, "Miscellaneous", props);
    }

    public Miscellaneous(UnitConfig config, String category, String caption, Properties<?> props) {
        category = Names.dotted().join(new String[]{category, caption});
        this.exposed = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"exposed", (boolean)props.exposed, (String)"Whether or not the ore blocks can be exposed to air.");
        this.proportions = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"proportions", (float)props.proportions, (FloatBounds)FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)), (String)"Ratio of height to width.\nValues > 1 result in tall veins (deposits).\nValues < 1 result in flat veins (deposits).");
        this.strictBounds = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"strictBounds", (boolean)props.strictBounds, (String)"If enabled, ore blocks will never spawn outside the given altitude bounds");
    }

    public static class Properties<T extends Properties<T>>
    extends BaseProperties<T> {
        public boolean exposed = true;
        public float proportions = 1.0f;
        public boolean strictBounds = false;

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T exposed(boolean value) {
            this.exposed = value;
            return (T)((Object)((Properties)this.self));
        }

        public T proportions(float value) {
            this.proportions = value;
            return (T)((Object)((Properties)this.self));
        }

        public T strictBounds() {
            this.strictBounds = true;
            return (T)((Object)((Properties)this.self));
        }
    }
}

