/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public interface IPole
extends IWaterLoggable {
    public static boolean isEmptyPlace(LevelReader level, BlockPos pos) {
        return !level.isOutsideBuildHeight(pos) && level.hasChunkAt(pos) && (GameWorld.isAirBlock(level, pos) || GameWorld.isWaterBlock(level, pos));
    }

    public static boolean replaceWith(BlockState state, ServerLevel level, BlockPos pos) {
        BlockEntity blockEntity;
        BlockState newState = IWaterLoggable.getStateForPlacementAt((LevelReader)level, pos, state);
        boolean result = level.setBlockAndUpdate(pos, newState);
        if (result && (blockEntity = level.getBlockEntity(pos)) instanceof ForgeTile) {
            ForgeTile tile = (ForgeTile)blockEntity;
            tile.syncWithClients();
        }
        return result;
    }

    public boolean isApex(BlockState var1);

    public boolean isPole(BlockState var1);

    default public boolean isApex(LevelReader level, BlockPos pos) {
        return level.hasChunkAt(pos) && this.isApex(level.getBlockState(pos));
    }

    default public boolean isPole(LevelReader level, BlockPos pos) {
        return level.hasChunkAt(pos) && this.isPole(level.getBlockState(pos));
    }

    default public boolean canBuildUp(Level level, BlockPos startPos) {
        BlockPos top = this.getTop((LevelReader)level, startPos).above();
        if (this.isApex((LevelReader)level, top)) {
            top = top.above();
        }
        return IPole.isEmptyPlace((LevelReader)level, top);
    }

    default public boolean canStayAt(LevelReader level, BlockPos pos) {
        BlockPos down = pos.below();
        if (this.isPole(level, down) || Block.canSupportCenter((LevelReader)level, (BlockPos)down, (Direction)Direction.UP)) {
            return true;
        }
        BlockPos up = pos.above();
        return this.isPole(level, up) || Block.canSupportCenter((LevelReader)level, (BlockPos)up, (Direction)Direction.DOWN);
    }

    default public BlockPos getTop(LevelReader level, BlockPos startPos) {
        return GameWorld.Positions.getLastInLine(level, startPos, this::isPole, Direction.UP);
    }

    default public BlockPos getBottom(LevelReader level, BlockPos startPos) {
        return GameWorld.Positions.getLastInLine(level, startPos, this::isPole, Direction.DOWN);
    }

    default public int buildUp(ServerLevel level, BlockPos from, BlockState poleToAdd, int quantity) {
        int i;
        if (!this.isPole((LevelReader)level, from)) {
            return 0;
        }
        BlockPos top = this.getTop((LevelReader)level, from);
        Optional<Apex> apex = this.isApex((LevelReader)level, top.above()) ? Optional.of(new Apex((Level)level, top.above())) : Optional.empty();
        int empty = 0;
        int n = i = apex.isPresent() ? 2 : 1;
        while (empty < quantity && IPole.isEmptyPlace((LevelReader)level, top.above(i))) {
            ++empty;
            ++i;
        }
        if ((quantity = Math.min(quantity, empty)) < 1) {
            return 0;
        }
        apex.ifPresent(Snapshot::removeBlock);
        for (int y = top.getY(); y >= from.getY(); --y) {
            BlockPos source = GameWorld.Positions.withY(from, y);
            BlockPos dest = source.above(quantity);
            Snapshot poleToMove = new Snapshot((Level)level, source);
            poleToMove.removeBlock();
            poleToMove.restoreAt((Level)level, dest);
        }
        int added = 0;
        for (int i2 = 0; i2 < quantity; ++i2) {
            if (!IPole.replaceWith(poleToAdd, level, from.above(i2))) continue;
            ++added;
        }
        if (apex.isPresent()) {
            ((Apex)apex.get()).restoreAt((Level)level, ((Apex)apex.get()).pos.above(quantity));
        }
        return added;
    }

    default public int breakDown(ServerLevel level, BlockPos from, int quantity, boolean dropItems) {
        if (!this.isPole((LevelReader)level, from)) {
            return 0;
        }
        BlockPos top = this.getTop((LevelReader)level, from);
        int poleLength = top.getY() - from.getY() + 1;
        quantity = Math.min(quantity, poleLength);
        Optional<Apex> apex = this.isApex((LevelReader)level, top.above()) ? Optional.of(new Apex((Level)level, top.above())) : Optional.empty();
        apex.ifPresent(Snapshot::removeBlock);
        int broken = 0;
        for (int i = 0; i < quantity; ++i) {
            if (!level.destroyBlock(from.above(i), dropItems)) continue;
            ++broken;
        }
        if (quantity < poleLength) {
            for (int y = from.getY(); y <= top.getY(); ++y) {
                BlockPos dest = GameWorld.Positions.withY(from, y);
                BlockPos source = dest.above(quantity);
                Snapshot snapshot = new Snapshot((Level)level, source);
                snapshot.removeBlock();
                snapshot.restoreAt((Level)level, dest);
            }
        }
        if (apex.isPresent()) {
            ((Apex)apex.get()).restoreAt((Level)level, ((Apex)apex.get()).pos.below(quantity));
        }
        return broken;
    }

    default public void playPlaceSound(Level level, BlockPos pos, BlockState state, Player player) {
        SoundType sound = state.getSoundType((LevelReader)level, pos, (Entity)player);
        level.playSound(player, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
    }

    default public ItemInteractionResult buildBy(Player player, Level level, BlockPos pos, InteractionHand hand, BlockHitResult hit, int quantity) {
        Block heldBlock;
        BlockState heldState;
        if (hit.getDirection().getAxis().isVertical()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack heldStack = player.getItemInHand(hand);
        UseOnContext context = new UseOnContext(player, hand, hit);
        if (!player.hasInfiniteMaterials()) {
            quantity = Math.min(quantity, heldStack.getCount());
        }
        if ((heldState = (heldBlock = Block.byItem((Item)heldStack.getItem())).getStateForPlacement(new BlockPlaceContext(context))) == null || !this.isPole(heldState)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int built = this.buildUp(server, pos, heldState, quantity);
            if (built > 0) {
                if (!player.hasInfiniteMaterials()) {
                    heldStack.shrink(built);
                }
                this.playPlaceSound(level, pos, heldState, player);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        } else if (this.canBuildUp(level, pos)) {
            this.playPlaceSound(level, pos, heldState, player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public void breakBy(Player player, ServerLevel level, BlockPos pos, int quantity) {
        boolean dropItems = !player.isCreative() && !player.isSpectator();
        this.breakDown(level, pos, quantity, dropItems);
    }

    public static class Apex
    extends Snapshot {
        public Apex(Level level, BlockPos pos) {
            super(level, pos);
        }
    }

    public static class Snapshot {
        final Level level;
        final BlockPos pos;
        final BlockState state;
        @Nullable
        final CompoundTag nbt;

        public Snapshot(Level level, BlockPos pos) {
            this.level = level;
            this.pos = pos;
            this.state = level.getBlockState(pos);
            this.nbt = Optional.ofNullable(level.getBlockEntity(pos)).map(be -> be.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess())).orElse(null);
        }

        public void removeBlock() {
            this.level.removeBlockEntity(this.pos);
            this.level.removeBlock(this.pos, false);
        }

        public void restoreAt(Level level, BlockPos pos) {
            BlockEntity tile;
            BlockState oldState = level.getBlockState(pos);
            BlockState newState = this.state;
            if (pos.getY() > this.pos.getY() && IWaterLoggable.isWaterlogged(newState)) {
                newState = (BlockState)newState.setValue((Property)IWaterLoggable.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            newState = IWaterLoggable.getStateForPlacementAt((LevelReader)level, pos, newState);
            level.setBlockAndUpdate(pos, newState);
            level.sendBlockUpdated(pos, oldState, newState, 3);
            if (this.nbt != null && (tile = level.getBlockEntity(pos)) != null) {
                CompoundTag nbt = this.nbt.copy();
                nbt.putInt("x", pos.getX());
                nbt.putInt("y", pos.getY());
                nbt.putInt("z", pos.getZ());
                tile.loadWithComponents(nbt, (HolderLookup.Provider)level.registryAccess());
                tile.setChanged();
                if (tile instanceof ForgeTile) {
                    ForgeTile te = (ForgeTile)tile;
                    te.syncWithClients();
                }
            }
        }
    }
}

