/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.BaseProperties;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BakedModelWrapper;

@OnlyIn(value=Dist.CLIENT)
public class ItemModel {
    public static final String INVENTORY = "inventory";

    public static ModelResourceLocation getInventoryLoc(Item item) {
        return new ModelResourceLocation(ForgeItem.getRegistryName(item), INVENTORY);
    }

    public static class Properties<T extends Properties<T>>
    extends BaseProperties<T> {
        protected final AbstractForgeMod mod;

        public static Properties<?> of(AbstractForgeMod mod) {
            return new Properties<Properties>(mod, Properties.class);
        }

        protected Properties(AbstractForgeMod mod, Class<T> selfClass) {
            super(selfClass);
            this.mod = mod;
        }

        public T register(Item item, String name, IPropertyGetter getter) {
            ItemProperties.register((Item)item, (ResourceLocation)this.mod.getNamespace().location(name), (ItemPropertyFunction)getter);
            return (T)((Properties)this.self);
        }

        public static interface IPropertyGetter
        extends ItemPropertyFunction {
            @Deprecated
            default public float call(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity living, int p_174679_) {
                return this.get(stack, Optional.ofNullable(world), Optional.ofNullable(living));
            }

            public float get(ItemStack var1, Optional<ClientLevel> var2, Optional<LivingEntity> var3);
        }
    }

    public static class RegistryWrapper {
        protected final Map<ResourceLocation, BakedModel> registry;

        public RegistryWrapper(Map<ResourceLocation, BakedModel> registry) {
            this.registry = registry;
        }

        @Nullable
        public BakedModel getModelOf(Item item) {
            ModelResourceLocation loc = ItemModel.getInventoryLoc(item);
            return this.registry.get(loc);
        }

        @Nullable
        public BakedModel getModelOf(BlockState state) {
            ModelResourceLocation location = BlockModelShaper.stateToModelLocation((BlockState)state);
            return this.registry.get(location);
        }

        public boolean replaceModelOf(Item item, BakedModel newModel) {
            ModelResourceLocation loc = ItemModel.getInventoryLoc(item);
            return this.registry.put((ResourceLocation)loc, newModel) != null;
        }

        public boolean replaceModelOf(BlockState state, BakedModel newModel) {
            ModelResourceLocation location = BlockModelShaper.stateToModelLocation((BlockState)state);
            return this.registry.put((ResourceLocation)location, newModel) != null;
        }

        public boolean replaceModelOf(Item item, IModelWrapperFactory<?> newModelFactory) {
            BakedModel original = this.getModelOf(item);
            if (original != null) {
                return this.replaceModelOf(item, (BakedModel)newModelFactory.create(original));
            }
            ForgeEndertech.getInstance().getLogger().error("Unable to find and replace item model for " + item.toString());
            return false;
        }

        public boolean replaceModelOf(BlockState state, IModelWrapperFactory<?> newModelFactory) {
            BakedModel original = this.getModelOf(state);
            if (original != null) {
                return this.replaceModelOf(state, (BakedModel)newModelFactory.create(original));
            }
            ForgeEndertech.getInstance().getLogger().error("Unable to find and replace block model for " + state.toString());
            return false;
        }
    }

    public static interface IModelWrapperFactory<T extends BakedModel> {
        public BakedModelWrapper<T> create(BakedModel var1);
    }

    public static class Combined
    implements BakedModel {
        protected final BakedModel baseModel;
        protected final BakedModel[] additionalModels;

        public Combined(BakedModel baseModel, BakedModel ... additionalModels) {
            this.baseModel = baseModel;
            this.additionalModels = additionalModels;
        }

        public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand) {
            ImmutableList.Builder quads = ImmutableList.builder();
            quads.addAll((Iterable)this.baseModel.getQuads(state, side, rand));
            for (BakedModel additional : this.additionalModels) {
                quads.addAll((Iterable)additional.getQuads(state, side, rand));
            }
            return quads.build();
        }

        public ItemOverrides getOverrides() {
            return ItemOverrides.EMPTY;
        }

        public boolean useAmbientOcclusion() {
            return this.baseModel.useAmbientOcclusion();
        }

        public boolean isGui3d() {
            return this.baseModel.isGui3d();
        }

        public boolean isCustomRenderer() {
            return this.baseModel.isCustomRenderer();
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.baseModel.getParticleIcon();
        }

        public ItemTransforms getTransforms() {
            return this.baseModel.getTransforms();
        }

        public boolean usesBlockLight() {
            return false;
        }
    }

    public static class BuiltIn
    extends BakedModelWrapper<BakedModel> {
        protected ItemOverrides overrides = null;
        protected Map<BakedModel, BuiltIn> builtInForModel = null;

        public BuiltIn(BakedModel originalModel) {
            super(originalModel);
        }

        public boolean isCustomRenderer() {
            return true;
        }

        public BakedModel applyTransform(ItemDisplayContext displayContext, PoseStack poseStack, boolean applyLeftHandTransform) {
            super.applyTransform(displayContext, poseStack, applyLeftHandTransform);
            return this;
        }

        public ItemOverrides getOverrides() {
            if (this.overrides == null) {
                this.overrides = new ItemOverrides(){

                    @Nullable
                    public BakedModel resolve(BakedModel modelIn, ItemStack stackIn, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int p_173469_) {
                        BuiltIn builtIn;
                        BakedModel model = originalModel.getOverrides().resolve(modelIn, stackIn, worldIn, entityIn, p_173469_);
                        if (model == null || model.isCustomRenderer()) {
                            return model;
                        }
                        if (builtInForModel == null) {
                            builtInForModel = new ConcurrentHashMap<BakedModel, BuiltIn>();
                        }
                        if ((builtIn = builtInForModel.get(model)) == null) {
                            builtIn = new BuiltIn(model);
                            builtInForModel.put(model, builtIn);
                        }
                        return builtIn;
                    }

                    public ImmutableList<ItemOverrides.BakedOverride> getOverrides() {
                        return originalModel.getOverrides().getOverrides();
                    }
                };
            }
            return this.overrides;
        }
    }

    public static abstract class Replacer<T extends BakedModel>
    extends BakedModelWrapper<T> {
        protected final ItemOverrides overrides = new ItemOverrides(){

            @Nullable
            public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity living, int p_173469_) {
                return this.chooseModelFor(stack, (Level)world, living);
            }
        };

        public Replacer(T originalModel) {
            super(originalModel);
        }

        public BakedModel applyTransform(ItemDisplayContext displayContext, PoseStack poseStack, boolean applyLeftHandTransform) {
            super.applyTransform(displayContext, poseStack, applyLeftHandTransform);
            return this;
        }

        public abstract BakedModel chooseModelFor(ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3);

        public ItemOverrides getOverrides() {
            return this.overrides;
        }
    }
}

