/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.units.UnitId;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class JsonGen {
    protected static JsonWriter createWriter(File file) throws IOException {
        FileUtils.createParentDirectories((File)file);
        JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new FileWriter(file)));
        writer.setIndent("\t");
        writer.setLenient(false);
        return writer;
    }

    protected static void print(Object obj) {
        System.out.println(obj.toString());
    }

    public static void blockState(ResourceLocation regName) throws IOException {
        GamePath path = GamePath.blockState(regName, new String[0]);
        JsonGen.print(path.absolute);
        JsonWriter writer = JsonGen.createWriter(path.absolute.toFile());
        writer.beginObject();
        writer.name("variants").beginObject();
        writer.name("").beginObject();
        writer.name("model").value(GamePath.blockModel((ResourceLocation)regName, (String[])new String[0]).shortcut.toString());
        writer.endObject().endObject().endObject();
        writer.close();
    }

    public static void blockModel(ResourceLocation regName, ResourceLocation parent, ResourceLocation texture) throws IOException {
        GamePath path = GamePath.blockModel(regName, new String[0]);
        JsonGen.print(path.absolute);
        JsonWriter writer = JsonGen.createWriter(path.absolute.toFile());
        writer.beginObject();
        writer.name("parent").value(parent.toString());
        writer.name("textures").beginObject();
        writer.name("0").value(texture.toString());
        writer.name("particle").value(texture.toString());
        writer.endObject().endObject();
        writer.close();
    }

    public static LootTableFile<?> blockLootTable(ResourceLocation regName) {
        GamePath path = GamePath.blockLootTable(regName);
        JsonGen.print(path.absolute);
        return new LootTableFile<LootTableFile>(LootTableFile.class, path.absolute.toFile());
    }

    public static void itemModel(ResourceLocation regName) throws IOException {
        GamePath path = GamePath.itemModel(regName, new String[0]);
        JsonGen.print(path.absolute.toString());
        JsonWriter writer = JsonGen.createWriter(path.absolute.toFile());
        writer.beginObject();
        writer.name("parent").value(GamePath.blockModel((ResourceLocation)regName, (String[])new String[0]).shortcut.toString());
        writer.endObject();
        writer.close();
    }

    public static LangFile<?> langFile(String modId, Locale locale) {
        GamePath path = GamePath.langFile(modId, locale);
        JsonGen.print(path.absolute);
        return new LangFile<LangFile>(LangFile.class, path.absolute.toFile());
    }

    public static RecipeFile<?> recipeFile(ResourceLocation regName) {
        GamePath path = GamePath.recipe(regName, new String[0]);
        JsonGen.print(path.absolute);
        return new RecipeFile<RecipeFile>(RecipeFile.class, path.absolute.toFile());
    }

    public static class LootTableFile<T extends LootTableFile<T>>
    extends BaseJsonFile<T> {
        protected Type type = Type.BLOCK;
        protected final List<Pool> pools = new ArrayList<Pool>();

        protected LootTableFile(Class<T> thisClass, File file) {
            super(thisClass, file);
        }

        public T type(Type type) {
            this.type = type;
            return (T)((LootTableFile)this.self);
        }

        public Pool beginPool(int rolls) {
            Pool pool = new Pool(rolls);
            this.pools.add(pool);
            return pool;
        }

        @Override
        public void end() throws IOException {
            this.writer.name("type").value(this.type.toString());
            this.writer.name("pools").beginArray();
            for (Pool pool : this.pools) {
                this.writer.beginObject();
                this.writer.name("rolls").value((long)pool.rolls);
                this.writer.name("entries").beginArray();
                for (KeyValuePair entry : pool.entries) {
                    this.writer.beginObject();
                    this.writer.name("type").value(entry.key());
                    this.writer.name("name").value(entry.value());
                    this.writer.endObject();
                }
                this.writer.endArray();
                this.writer.name("conditions").beginArray();
                for (String condition : pool.conditions) {
                    this.writer.beginObject().name("condition").value(condition).endObject();
                }
                this.writer.endArray();
                this.writer.endObject();
            }
            this.writer.endArray();
            super.end();
        }

        public static enum Type implements IForgeEnum
        {
            ITEM,
            BLOCK;


            public String toString() {
                return new ResourceLocation(this.getName()).toString();
            }
        }

        public class Pool {
            public final int rolls;
            protected final List<KeyValuePair> entries = new ArrayList<KeyValuePair>();
            protected final List<String> conditions = new ArrayList<String>();

            public Pool(int rolls) {
                this.rolls = rolls;
            }

            public Pool addEntry(String type, String name) {
                KeyValuePair entry = new KeyValuePair(type, name);
                this.entries.add(entry);
                return this;
            }

            public Pool addBlock(ResourceLocation regName) {
                return this.addEntry(Type.BLOCK.toString(), regName.toString());
            }

            public Pool addItem(ResourceLocation regName) {
                return this.addEntry(Type.ITEM.toString(), regName.toString());
            }

            public Pool addCondition(String condition) {
                this.conditions.add(condition);
                return this;
            }

            public Pool addCondition(Condition condition) {
                return this.addCondition(condition.toString());
            }

            public T endPool() {
                return (LootTableFile)LootTableFile.this.self;
            }
        }

        public static enum Condition implements IForgeEnum
        {
            SURVIVES_EXPLOSION;


            public String toString() {
                return new ResourceLocation(this.getName()).toString();
            }
        }
    }

    public static class LangFile<T extends LangFile<T>>
    extends BaseJsonFile<T> {
        protected LangFile(Class<T> thisClass, File file) {
            super(thisClass, file);
        }

        public T addItemGroup(String name, String localizedName) throws IOException {
            this.writer.name(Names.dotted().join("itemGroup", name)).value(localizedName);
            return (T)((LangFile)this.self);
        }

        public T addBlock(ResourceLocation regName) throws IOException {
            String localizedName = Names.localized().join(UnitId.splitRegName(regName.getPath(), true, false));
            return this.addBlock(regName, localizedName);
        }

        public T addBlock(ResourceLocation regName, String localizedName) throws IOException {
            this.writer.name(Names.dotted().join("block", regName.getNamespace(), regName.getPath())).value(localizedName);
            return (T)((LangFile)this.self);
        }

        public T addItem(ResourceLocation regName, String localizedName) throws IOException {
            this.writer.name(Names.dotted().join("item", regName.getNamespace(), regName.getPath())).value(localizedName);
            return (T)((LangFile)this.self);
        }
    }

    public static class RecipeFile<T extends RecipeFile<T>>
    extends BaseJsonFile<T> {
        protected String type = "minecraft:crafting_shaped";
        protected String[] pattern;
        protected List<KeyValuePair> items = new ArrayList<KeyValuePair>();
        protected KeyValuePair result;

        protected RecipeFile(Class<T> thisClass, File file) {
            super(thisClass, file);
        }

        public T type(String type) {
            this.type = type;
            return (T)((RecipeFile)this.self);
        }

        public T pattern(String ... rows) throws IOException {
            this.pattern = rows;
            return (T)((RecipeFile)this.self);
        }

        public T addItem(String key, ResourceLocation item) {
            this.items.add(new KeyValuePair(key, item.toString()));
            return (T)((RecipeFile)this.self);
        }

        public T result(ResourceLocation item, int count) {
            this.result = new KeyValuePair(item.toString(), String.valueOf(count));
            return (T)((RecipeFile)this.self);
        }

        @Override
        public void end() throws IOException {
            this.writer.name("type").value(this.type);
            this.writer.name("pattern");
            this.writer.beginArray();
            for (String row : this.pattern) {
                this.writer.value(row);
            }
            this.writer.endArray();
            this.writer.name("key").beginObject();
            for (KeyValuePair entry : this.items) {
                this.writer.name(entry.key()).beginObject().name("item").value(entry.value()).endObject();
            }
            this.writer.endObject();
            this.writer.name("result").beginObject();
            this.writer.name("item").value(this.result.key());
            this.writer.name("count").value((long)Integer.parseInt(this.result.value()));
            this.writer.endObject();
            super.end();
        }
    }

    public static class Tags<T extends Tags<T>>
    extends BaseJsonFile<T> {
        protected final boolean replace;
        protected final List<String> values;

        public static Tags<?> mineableBlocks(String namespace, String tool, boolean replace) {
            return new Tags<Tags>(Tags.class, namespace, "blocks/mineable", tool, replace);
        }

        protected Tags(Class<T> thisClass, File file, boolean replace) {
            super(thisClass, file);
            this.replace = replace;
            this.values = new ArrayList<String>();
        }

        protected Tags(Class<T> thisClass, String namespace, String folder, String fileName, boolean replace) {
            this(thisClass, GamePath.DATA.resolve(namespace).resolve("tags").resolve(folder).resolve(fileName + GamePath.Extensions.JSON.getWithDot()).toFile(), replace);
        }

        public T add(ResourceLocation location) {
            this.values.add(location.toString());
            return (T)((Tags)this.self);
        }

        @Override
        public void end() throws IOException {
            this.writer.name("replace").value(this.replace);
            this.writer.name("values").beginArray();
            for (String value : this.values) {
                this.writer.value(value);
            }
            this.writer.endArray();
            super.end();
        }
    }

    public static abstract class BaseJsonFile<T extends BaseJsonFile<T>> {
        protected final T self;
        protected final File file;
        protected JsonWriter writer;

        protected BaseJsonFile(Class<T> thisClass, File file) {
            this.self = (BaseJsonFile)thisClass.cast(this);
            this.file = file;
        }

        public T begin() throws Exception {
            if (this.writer != null) {
                throw new Exception("Writer for " + this.file.toString() + " already created!");
            }
            this.writer = JsonGen.createWriter(this.file).beginObject();
            return this.self;
        }

        public void end() throws IOException {
            this.writer.endObject().close();
        }
    }
}

