/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public final class TagHelper {
    public static boolean hasCompoundTag(CompoundTag compound, String tagName) {
        return compound.contains(tagName, Types.COMPOUND.id);
    }

    @Nullable
    public static CompoundTag getNestedCompound(CompoundTag compound, String path) {
        String[] split;
        if (path.isEmpty()) {
            return compound;
        }
        for (String key : split = path.split("/")) {
            Tag tag = compound.get(key);
            if (!(tag instanceof CompoundTag)) {
                return null;
            }
            compound = (CompoundTag)tag;
        }
        return compound;
    }

    @Nullable
    public static Tag getTag(CompoundTag compound, KeyPathPair pair) {
        return (compound = TagHelper.getNestedCompound(compound, pair.path)) != null ? compound.get(pair.key) : null;
    }

    public static Types getType(CompoundTag compound, String key) {
        byte id = compound.getTagType(key);
        for (Types type : Types.values()) {
            if (type.id != id) continue;
            return type;
        }
        return Types.NULL;
    }

    public static void putVect3d(CompoundTag compound, String key, Vect3d vec) {
        CompoundTag tag = new CompoundTag();
        tag.putDouble(Vec3Keys.x.name(), vec.x);
        tag.putDouble(Vec3Keys.y.name(), vec.y);
        tag.putDouble(Vec3Keys.z.name(), vec.z);
        compound.put(key, (Tag)tag);
    }

    public static Vect3d getVect3d(CompoundTag compound, String key) {
        CompoundTag tag = compound.getCompound(key);
        return Vect3d.from(tag.getDouble(Vec3Keys.x.name()), tag.getDouble(Vec3Keys.y.name()), tag.getDouble(Vec3Keys.z.name()));
    }

    public static void putBlockPos(CompoundTag compound, String key, BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putInt(Vec3Keys.x.name(), pos.getX());
        tag.putInt(Vec3Keys.y.name(), pos.getY());
        tag.putInt(Vec3Keys.z.name(), pos.getZ());
        compound.put(key, (Tag)tag);
    }

    public static BlockPos getBlockPos(CompoundTag compound, String key) {
        CompoundTag tag = compound.getCompound(key);
        return new BlockPos(tag.getInt(Vec3Keys.x.name()), tag.getInt(Vec3Keys.y.name()), tag.getInt(Vec3Keys.z.name()));
    }

    @Nullable
    public static <T extends Enum<T>> T getEnumValue(CompoundTag compound, Class<T> enumClass) {
        String name = compound.getString(enumClass.getSimpleName());
        return name.isEmpty() ? null : (T)Enum.valueOf(enumClass, name);
    }

    public static <T extends Enum<T>> void putEnumValue(CompoundTag compound, T enumValue) {
        compound.putString(enumValue.getClass().getSimpleName(), enumValue.name());
    }

    public static String[] getStringArray(CompoundTag compound, String key) {
        ListTag list = compound.getList(key, Types.STRING.id);
        int count = list.size();
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = list.getString(i);
        }
        return strings;
    }

    public static void putStringArray(CompoundTag compound, String key, String ... strings) {
        ListTag list = new ListTag();
        for (String str : strings) {
            StringTag tag = StringTag.valueOf((String)str);
            list.add((Object)tag);
        }
        compound.put(key, (Tag)list);
    }

    public static <T> List<T> getByTag(String tag, IForgeRegistry<T> registry) {
        ITagManager allTags = registry.tags();
        if (allTags != null) {
            ResourceLocation location = UnitId.from(tag).toResLoc();
            return allTags.getTagNames().filter(name -> name.location().equals((Object)location)).filter(arg_0 -> ((ITagManager)allTags).isKnownTagName(arg_0)).map(arg_0 -> ((ITagManager)allTags).getTag(arg_0)).flatMap(ITag::stream).toList();
        }
        return Collections.emptyList();
    }

    public static enum Types {
        NULL(0),
        BYTE(1),
        SHORT(2),
        INT(3),
        LONG(4),
        FLOAT(5),
        DOUBLE(6),
        BYTE$$(7),
        STRING(8),
        LIST(9),
        COMPOUND(10),
        INT$$(11),
        LONG$$(12),
        ORDINAL(99);

        public final int id;

        private Types(int id) {
            this.id = id;
        }

        public boolean isOrdinal() {
            return this.id == 99 || this.id >= 1 && this.id <= 6;
        }

        public String toString() {
            String string = this.name().toLowerCase(Locale.ROOT);
            return this.isOrdinal() ? string : CommonString.capitalizeFirstChar(string).replace("$$", "[]");
        }
    }

    public record KeyPathPair(String path, String key) {
        public static KeyPathPair parse(String str) {
            int pos = str.lastIndexOf("/");
            if (pos < 0) {
                return new KeyPathPair("", str);
            }
            return new KeyPathPair(str.substring(0, pos), str.substring(pos + 1));
        }
    }

    static enum Vec3Keys {
        x,
        y,
        z;

    }

    static enum UUIDKeys {
        m,
        l;

    }
}

