/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameTime;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public abstract class ConsumableItem
extends ForgeItem {
    private final int maxUseDuration;

    public ConsumableItem(UnitConfig config, ForgeItem.Properties<?> props, CommonTime.Interval consumeDuration) {
        super(config, props);
        consumeDuration = UnitConfig.getTimeInSeconds(config, props.name, "consumeDuration", consumeDuration, "Defines time required for item to be consumed.");
        this.maxUseDuration = (int)GameTime.inServerTicks(consumeDuration);
    }

    public abstract UseAnim getUseAnimation(ItemStack var1);

    public int getUseDuration(ItemStack stack) {
        return this.maxUseDuration;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity living) {
        Player player;
        Player player2 = player = living instanceof Player ? (Player)living : null;
        if (player == null || !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        return super.finishUsingItem(stack, world, living);
    }
}

