/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitProperties;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeItem
extends Item
implements IHaveConfig {
    private final UnitConfig config;

    public ForgeItem(UnitConfig config, Properties<?> properties) {
        super(properties.vanillaProps);
        this.config = config;
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static void damageItem(ItemStack stack, int damage, boolean destroyBroken, LivingEntity entity) {
        ForgeItem.damageItem(stack, damage, destroyBroken, entity, () -> {});
    }

    public static void damageItem(ItemStack stack, int damage, boolean destroyBroken, LivingEntity entity, Runnable onBroken) {
        ServerPlayer serverplayer;
        Player player;
        if (entity.level().isClientSide()) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).hasInfiniteMaterials()) {
            return;
        }
        stack.hurtAndBreak(damage, entity.getRandom(), entity instanceof ServerPlayer ? (serverplayer = (ServerPlayer)entity) : null, () -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.awardStat(Stats.ITEM_BROKEN.get((Object)stack.getItem()));
            }
            if (destroyBroken) {
                stack.shrink(1);
                stack.setDamageValue(0);
            }
            onBroken.run();
        });
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.isDamageableItem() && stack.getDamageValue() >= stack.getMaxDamage();
    }

    public static boolean notBroken(ItemStack stack) {
        return !ForgeItem.isBroken(stack);
    }

    public static Optional<Integer> indexIn(Inventory inventory, Predicate<ItemStack> predicate) {
        int size = inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(inventory.getItem(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public final Item.Properties vanillaProps = new Item.Properties();

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }
    }
}

