/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.DimensionId;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class Connection {
    private static final int PROTOCOL_VERSION = 1;
    private final SimpleChannel channel;

    public Connection(String modId, AbstractForgeMod.RequiredSide requiredSide) {
        ResourceLocation name = new ResourceLocation(modId, "main");
        ChannelBuilder builder = ChannelBuilder.named((ResourceLocation)name).networkProtocolVersion(1);
        switch (requiredSide) {
            case SERVER: {
                builder.optionalClient();
                break;
            }
            case CLIENT: {
                builder.optionalServer();
            }
        }
        this.channel = builder.simpleChannel();
    }

    public <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(MSG msg) {
        Class<?> msgType = msg.getClass();
        this.channel.messageBuilder(msgType).encoder(msg::encode).decoder(msg::decode).consumerNetworkThread(msg::consume).add();
    }

    public <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        this.channel.send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    public <MSG> void sendToServer(MSG message) {
        this.channel.send(message, PacketDistributor.SERVER.noArg());
    }

    public <MSG> void sendToAll(MSG message) {
        this.getServerPlayers().forEach(player -> this.sendToPlayer(message, (ServerPlayer)player));
    }

    public <MSG> void sendToAllInDimension(MSG message, DimensionId dimension) {
        for (ServerPlayer player : this.getServerPlayers()) {
            if (!dimension.belongsTo(player.level())) continue;
            this.sendToPlayer(message, player);
        }
    }

    public <MSG> void sendToAllAround(MSG message, ServerLevelAccessor world, BlockPos pos, int radius) {
        DimensionId dimension = DimensionId.from((Level)world.getLevel());
        for (ServerPlayer player : this.getServerPlayers()) {
            double distSqr;
            if (!dimension.belongsTo(player.level()) || !((distSqr = pos.distSqr((Vec3i)player.blockPosition())) <= (double)(radius * radius))) continue;
            this.sendToPlayer(message, player);
        }
    }

    public <MSG> void sendToAllObservingChunk(MSG message, LevelChunk chunk) {
        this.channel.send(message, PacketDistributor.TRACKING_CHUNK.with((Object)chunk));
    }

    public <MSG> void sendToAllAround(MSG message, PacketDistributor.TargetPoint point) {
        this.channel.send(message, PacketDistributor.NEAR.with((Object)point));
    }

    public <MSG> void sendToAllInChunk(MSG message, ChunkLoc location) {
        for (ServerPlayer player : this.getServerPlayers()) {
            if (!location.contains((Entity)player)) continue;
            this.sendToPlayer(message, player);
        }
    }

    public List<ServerPlayer> getServerPlayers() {
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers();
    }
}

