/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.network.TileSharedDataMsg;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ForgeTile
extends BlockEntity {
    public static <T extends BlockEntity> BlockEntityType.Builder<T> builder(BlockEntityType.BlockEntitySupplier<? extends T> factory, Collection<? extends Block> validBlocks) {
        return ForgeTile.builder(factory, validBlocks.toArray(new Block[0]));
    }

    public static <T extends BlockEntity> BlockEntityType.Builder<T> builder(BlockEntityType.BlockEntitySupplier<? extends T> factory, Block ... validBlocks) {
        return BlockEntityType.Builder.of(factory, (Block[])validBlocks);
    }

    public static Optional<ResourceLocation> getRegistryName(BlockEntity tile) {
        return Optional.ofNullable(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tile.getType()));
    }

    public ForgeTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::saveCustomOnly);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookup) {
        super.onDataPacket(connection, pkt, lookup);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag compound, HolderLookup.Provider registries) {
        this.loadWithComponents(compound, registries);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.readSharedData(compound, registries);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        this.writeSharedData(compound, registries);
    }

    public CompoundTag getSharedData() {
        CompoundTag data = new CompoundTag();
        return Optional.ofNullable(this.getLevel()).map(Level::registryAccess).map(reg -> this.writeSharedData(data, (HolderLookup.Provider)reg)).orElse(data);
    }

    public void syncWithClients() {
        Level level = this.getLevel();
        if (level != null && GameWorld.isServerSide((LevelReader)level)) {
            TileSharedDataMsg message = new TileSharedDataMsg(this.getSharedData(), this.getBlockPos());
            ForgeEndertech.getInstance().getConnection().sendToAllObservingChunk(message, level.getChunkAt(this.getBlockPos()));
            this.setChanged();
        }
    }

    public abstract void readSharedData(CompoundTag var1, HolderLookup.Provider var2);

    public abstract CompoundTag writeSharedData(CompoundTag var1, HolderLookup.Provider var2);
}

