/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class RegistryObjectsInit<O>
extends UnitsInit<O> {
    protected final ResourceKey<Registry<O>> registryKey;
    protected final DeferredRegister<O> deferredRegister;

    public RegistryObjectsInit(AbstractForgeMod mod, IForgeRegistry<O> registry) {
        this(mod, registry.getRegistryKey());
    }

    protected RegistryObjectsInit(AbstractForgeMod mod, ResourceKey<Registry<O>> registryKey) {
        super(mod);
        this.registryKey = registryKey;
        this.deferredRegister = DeferredRegister.create(registryKey, (String)mod.getId());
        this.deferredRegister.register(mod.getModEventBus());
        mod.getModEventBus().addListener(event -> {
            if (registryKey.equals((Object)event.getRegistryKey())) {
                this.onRegistration((RegisterEvent)event);
            }
        });
    }

    public <U extends O> RegistryObject<U> register(String name, Supplier<U> supplier) {
        Lazy<U> unit = this.addUnit(name, supplier);
        return this.deferredRegister.register(name, unit);
    }

    public <U extends O> RegistryObject<U> register(String name, Function<String, U> nameToUnit) {
        return this.register(name, () -> nameToUnit.apply(name));
    }

    public <U extends O, RO> RegistryObject<U> register(RegistryObject<RO> registryObject, BiFunction<String, RO, U> name_objectToUnit) {
        String name = registryObject.getId().getPath();
        return this.register(name, () -> name_objectToUnit.apply(name, registryObject.get()));
    }

    protected void onRegistration(RegisterEvent event) {
    }
}

