/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.math.Percentage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;

public class DepositGenResult
implements INBTSerializable<DepositGenResult> {
    public static final DepositGenResult EMPTY = new DepositGenResult("", BlockPos.ZERO, 0, 0);
    public final String name;
    public final BlockPos pos;
    public final int size;
    public final int deferred;

    public DepositGenResult(String name, BlockPos pos, int size, int deferred) {
        this.name = name;
        this.pos = pos;
        this.size = size;
        this.deferred = deferred;
    }

    public boolean isEmpty() {
        return this.size == 0 || this.name.isEmpty() || this.pos.equals((Object)BlockPos.ZERO);
    }

    public boolean isComplete() {
        return this.deferred == 0;
    }

    public Percentage completeness() {
        return Percentage.from((int)this.size, (int)(this.size + this.deferred));
    }

    public DepositGenResult readFrom(CompoundTag compound) {
        CompoundTag tag = compound.getCompound("DepositGenResult");
        String name = tag.getString("name");
        BlockPos pos = BlockPos.of((long)tag.getLong("pos"));
        int size = tag.getInt("size");
        int deferred = tag.getInt("deferred");
        return new DepositGenResult(name, pos, size, deferred);
    }

    public CompoundTag writeTo(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        tag.putString("name", this.name);
        tag.putLong("pos", this.pos.asLong());
        tag.putInt("size", this.size);
        tag.putInt("deferred", this.deferred);
        compound.put("DepositGenResult", (Tag)tag);
        return compound;
    }

    public String toString() {
        String chunk = "Chunk" + String.valueOf(new ChunkPos(this.pos));
        return this.getClass().getSimpleName() + ": " + Args.group((Object[])new Object[]{Args.get((String)"Name", (Object)this.name), Args.get((String)"Size", (Object)this.size), this.completeness(), this.pos, chunk});
    }
}

