/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.DimensionId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import com.endertech.minecraft.mods.adlods.ore.Replacements;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractOre
implements IHaveConfig {
    protected final UnitConfig config;
    protected final CommonCollect.BlackWhiteList<BiomeId> biomes;
    protected final CommonCollect.BlackWhiteList<DimensionId> dimensions;
    protected final IntBounds altitude;
    protected final BlockStatesSet replaceableBlocks;
    protected final Replacements replacements;
    protected final Miscellaneous miscellaneous;

    public AbstractOre(UnitConfig config, Properties<?> props) {
        String category = this.getClassCategory();
        this.config = config;
        this.dimensions = Dimensions.from((UnitConfig)config, (String)category, (String)"List of dimensions which this ore can be generated in.", (String[])new String[0], (String[])props.allowedDimensions);
        this.biomes = Biomes.from((UnitConfig)config, (String)category, (String)"List of biomes which this ore can be generated in.");
        this.altitude = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Altitude", (IntBounds)props.altitude, (IntBounds)IntBounds.INTEGER, (String)"Altitude which this ore can be generated at.");
        this.replaceableBlocks = BlockStatesSet.parseFrom((String[])UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"replaceableBlocks", (String[])props.replaceableBlocks, (String)"List of blocks that can be replaced with this ore."));
        this.replacements = Replacements.custom(config, category, props.customReplacements, this::pickState);
        this.miscellaneous = Miscellaneous.of(config, category, props.miscellaneous);
        this.saveConfig();
    }

    protected abstract int generate(WorldGenLevel var1, BlockPos var2, int var3, boolean var4, Random var5);

    public abstract boolean isValid();

    public static boolean inAdjacentChunk(BlockPos pos, ChunkPos center, boolean includeCorners) {
        ChunkPos check = new ChunkPos(pos);
        int dX = Math.abs(center.x - check.x);
        int dZ = Math.abs(center.z - check.z);
        return includeCorners ? dX <= 1 && dZ <= 1 : dX == 0 && dZ <= 1 || dZ == 0 && dX <= 1;
    }

    public static boolean withinGenRegion(ChunkPos chunk, ChunkPos start) {
        return AbstractOre.withinRadius(chunk, start, 1);
    }

    public static boolean withinRadius(ChunkPos chunk, ChunkPos center, int radius) {
        int dX = Math.abs(center.x - chunk.x);
        int dZ = Math.abs(center.z - chunk.z);
        return dX <= radius && dZ <= radius;
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    public IntBounds getAltitude() {
        return this.altitude;
    }

    public Replacements getReplacements() {
        return this.replacements;
    }

    public boolean inAllowedDimenstion(ServerLevelAccessor world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)DimensionId.from((Level)world.getLevel()));
    }

    public boolean inAllowedBiome(LevelAccessor world, BlockPos pos) {
        return this.biomes.isEmpty() || this.biomes.isAllowed((Object)BiomeId.from((LevelAccessor)world, (BlockPos)pos));
    }

    protected boolean isAllowedOre(BlockState state) {
        String name = ForgeBlock.getRegistryName((Block)state.getBlock()).getPath();
        if (name.contains("nether")) {
            return this.dimensions.isAllowed((Object)Dimensions.THE_NETHER.dimensionId);
        }
        if (name.startsWith("end_")) {
            return this.dimensions.isAllowed((Object)Dimensions.THE_END.dimensionId);
        }
        return true;
    }

    protected Optional<BlockState> pickState(UnitId oreId) {
        Predicate<BlockState> filter = this::isAllowedOre;
        return Optional.ofNullable(oreId.getFirstMatchedState()).filter(filter).or(() -> Optional.ofNullable(oreId.getAllMatchedBlockStates()).flatMap(set -> set.getBlocksWithAllStates().stream().map(Block::defaultBlockState).filter(filter).findFirst().or(() -> set.stream().filter(filter).findFirst())));
    }

    protected boolean replaceWithOre(LevelAccessor level, BlockPos pos, boolean testing, Random random) {
        boolean replaced;
        BlockState replaceableBlock = testing ? (BlockState)this.replaceableBlocks.getBlocksWithAllStates().stream().findFirst().map(Block::defaultBlockState).or(() -> this.replaceableBlocks.stream().findFirst()).orElse(null) : level.getBlockState(pos);
        BlockState state = this.replacements.pickOreFor(replaceableBlock, random).map(WeightedOre::getBlockState).orElse(null);
        boolean bl = replaced = state != null && level.setBlock(pos, state, 18);
        if (replaced && !state.getFluidState().isEmpty()) {
            level.scheduleTick(pos, state.getFluidState().getType(), level.getRandom().nextIntBetweenInclusive(0, 60));
        }
        return replaced;
    }

    public boolean canBeReplaced(LevelAccessor level, BlockPos pos, boolean testing) {
        if (testing && GameWorld.isAirBlock((LevelReader)level, (BlockPos)pos)) {
            return true;
        }
        BlockState state = level.getBlockState(pos);
        return this.replacements.haveReplacementFor(state);
    }

    public boolean isValidPosition(WorldGenLevel level, BlockPos pos, BlockPos start, BlockPos origin, boolean testing) {
        if (level instanceof WorldGenRegion && !AbstractOre.withinGenRegion(new ChunkPos(pos), new ChunkPos(start))) {
            return false;
        }
        if (!this.withinHeightBounds(level, pos, start, origin, testing)) {
            return false;
        }
        if ((this.miscellaneous.strictBounds || pos.equals((Object)origin)) && !testing && !this.inAllowedBiome((LevelAccessor)level, pos)) {
            return false;
        }
        return testing || this.miscellaneous.exposed || !this.exposedToAir((LevelAccessor)level, pos);
    }

    protected boolean withinHeightBounds(WorldGenLevel level, BlockPos pos, BlockPos start, BlockPos origin, boolean testing) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        if (this.miscellaneous.strictBounds || pos.equals((Object)origin)) {
            return testing ? Math.abs(pos.getY() - start.getY()) <= this.altitude.length() / 2 : this.altitude.encloses(Integer.valueOf(pos.getY()));
        }
        return true;
    }

    protected boolean exposedToAir(LevelAccessor world, BlockPos posIn) {
        for (BlockPos pos : GameWorld.Positions.getAroundCube((BlockPos)posIn)) {
            if (!GameWorld.isBlockLoaded((LevelReader)world, (BlockPos)pos)) {
                return true;
            }
            if (!GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos)) continue;
            return true;
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public IntBounds altitude = IntBounds.ZERO;
        public String[] replaceableBlocks = new String[0];
        public String[] allowedDimensions = new String[0];
        public String[] customReplacements = new String[0];
        public Miscellaneous.Properties<?> miscellaneous = Miscellaneous.Properties.of();

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T dimension(Dimensions dimension) {
            return ((Properties)((Object)this.allowedDimensions(dimension.dimensionId.toResourceLocation().toString()))).replaceableBlocks(dimension.replaceableBlockId.toString());
        }

        public T altitude(int min, int max) {
            this.altitude = IntBounds.between((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T allowedDimensions(String ... dimensions) {
            this.allowedDimensions = dimensions;
            return (T)((Object)((Properties)this.self));
        }

        public T deepslate(String ore) {
            String deepslate = "deepslate";
            String target = "#minecraft:deepslate_ore_replaceables";
            String replacement = ore.contains("deepslate") ? ore : Names.registry().join(new String[]{"deepslate", ore});
            return this.customReplacements("#minecraft:deepslate_ore_replaceables -> " + replacement);
        }

        public T replaceableBlocks(String ... blocks) {
            this.replaceableBlocks = blocks;
            return (T)((Object)((Properties)this.self));
        }

        public T customReplacements(String ... replacements) {
            this.customReplacements = replacements;
            return (T)((Object)((Properties)this.self));
        }

        public T exposed(boolean value) {
            this.miscellaneous.exposed(value);
            return (T)((Object)((Properties)this.self));
        }
    }
}

