/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepaintableBlockModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<BlockState> BLOCK_STATE = new ModelProperty();
    protected final Map<BlockState, SimpleBakedModel> retexturedModels = new ConcurrentHashMap<BlockState, SimpleBakedModel>();

    public RepaintableBlockModel(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        BlockState targetBlock = this.getTargetBlock(extraData).orElse(null);
        if (targetBlock == null || targetBlock == state || targetBlock.isAir()) {
            return this.originalModel.getQuads(state, side, rand, extraData, renderType);
        }
        BakedModel retexturedModel = (BakedModel)this.retexturedModels.computeIfAbsent(targetBlock, key -> {
            BakedModel targetModel = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(targetBlock);
            TextureAtlasSprite oldTexture = this.getMainTextureSprite(this.originalModel, state, rand, renderType);
            TextureAtlasSprite newTexture = targetModel != this ? this.getMainTextureSprite(targetModel, targetBlock, rand, renderType) : oldTexture;
            TextureAtlasSprite particleIcon = targetModel.getParticleIcon(ModelData.EMPTY);
            float scale = (float)this.getMinSize(particleIcon) / (float)this.getMinSize(newTexture);
            return this.createRetexturedModel(state, scale, rand, renderType, oldTexture, newTexture);
        });
        return retexturedModel.getQuads(state, side, rand, extraData, renderType);
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.getTargetBlock(data).map(this.retexturedModels::get).map(model -> model.getParticleIcon(data)).orElseGet(() -> this.originalModel.getParticleIcon(data));
    }

    protected Optional<BlockState> getTargetBlock(ModelData data) {
        return data.has(BLOCK_STATE) ? Optional.ofNullable((BlockState)data.get(BLOCK_STATE)) : Optional.empty();
    }

    protected int getMinSize(TextureAtlasSprite sprite) {
        int min = Math.min(sprite.contents().width(), sprite.contents().height());
        return Math.max(min, 1);
    }

    protected TextureAtlasSprite getMainTextureSprite(BakedModel model, BlockState state, RandomSource rand, @Nullable RenderType renderType) {
        Direction[] directions;
        TextureAtlasSprite mainSprite = model.getParticleIcon(ModelData.EMPTY);
        if (model instanceof RepaintableBlockModel) {
            return mainSprite;
        }
        HashSet allSprites = new HashSet();
        HashMap culledSprites = new HashMap();
        for (Direction side : directions = Direction.values()) {
            Set sprites = model.getQuads(state, side, rand, ModelData.EMPTY, renderType).stream().map(BakedQuad::getSprite).collect(Collectors.toSet());
            culledSprites.put(side, sprites);
            allSprites.addAll(sprites);
        }
        if (state.is(Blocks.GRASS_BLOCK)) {
            return Optional.ofNullable((Set)culledSprites.get(Direction.DOWN)).flatMap(set -> set.stream().findFirst()).orElse(mainSprite);
        }
        int maxCount = 0;
        for (TextureAtlasSprite sprite : allSprites) {
            int count = 0;
            for (Direction side : directions) {
                if (!((Set)culledSprites.get(side)).contains(sprite)) continue;
                ++count;
            }
            if (count <= maxCount) continue;
            mainSprite = sprite;
            maxCount = count;
        }
        return mainSprite;
    }

    protected SimpleBakedModel createRetexturedModel(@Nullable BlockState state, float scale, @NotNull RandomSource rand, @Nullable RenderType renderType, TextureAtlasSprite oldTexture, TextureAtlasSprite newTexture) {
        List<BakedQuad> unculledFaces = this.originalModel.getQuads(state, null, rand, ModelData.EMPTY, renderType).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture, scale)).toList();
        EnumMap<Direction, List<BakedQuad>> culledFaces = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction direction : Direction.values()) {
            culledFaces.put(direction, this.originalModel.getQuads(state, direction, rand, ModelData.EMPTY, renderType).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture, scale)).toList());
        }
        return new SimpleBakedModel(unculledFaces, culledFaces, this.originalModel.useAmbientOcclusion(), this.originalModel.usesBlockLight(), this.originalModel.isGui3d(), newTexture, this.originalModel.getTransforms(), this.originalModel.getOverrides());
    }

    protected BakedQuad retextureQuad(BakedQuad quad, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite, float scale) {
        if (!oldSprite.equals(newSprite) && quad.getSprite().equals(oldSprite)) {
            int[] updatedVerticies = this.updateVertices(quad.getVertices(), quad.getSprite(), newSprite, scale);
            return new BakedQuad(updatedVerticies, quad.getTintIndex(), quad.getDirection(), newSprite, quad.isShade());
        }
        return quad;
    }

    protected int[] updateVertices(int[] vertices, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite, float scale) {
        int[] updatedVertices = (int[])vertices.clone();
        int vertexSize = DefaultVertexFormat.BLOCK.getVertexSize();
        int integerSize = vertexSize / 4;
        for (int i = 0; i < vertexSize; i += integerSize) {
            int offset = i + IQuadTransformer.UV0;
            float u = this.getUV(Float.intBitsToFloat(vertices[offset]), oldSprite.getU0(), oldSprite.getU1());
            float v = this.getUV(Float.intBitsToFloat(vertices[offset + 1]), oldSprite.getV0(), oldSprite.getV1());
            updatedVertices[offset] = Float.floatToRawIntBits(newSprite.getU(u * scale));
            updatedVertices[offset + 1] = Float.floatToRawIntBits(newSprite.getV(v * scale));
        }
        return updatedVertices;
    }

    protected float getUV(float uv, float uv0, float uv1) {
        return (float)((double)(uv - uv0) * 1.0 / (double)(uv1 - uv0));
    }
}

