/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public abstract class ChestWearItemLayer<L extends LivingEntity, M extends HumanoidModel<L>>
extends RenderLayer<L, M> {
    public ChestWearItemLayer(RenderLayerParent<L, M> entityRenderer) {
        super(entityRenderer);
    }

    public ModelPart getChestRenderer() {
        return ((HumanoidModel)this.getParentModel()).body;
    }

    public abstract boolean shouldRender(ItemStack var1, L var2);

    public ItemStack getWearItem(L livingEntity) {
        return livingEntity.getItemBySlot(EquipmentSlot.CHEST);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, L livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack wearItem = this.getWearItem(livingEntity);
        if (!this.shouldRender(wearItem, livingEntity)) {
            return;
        }
        poseStack.pushPose();
        if (livingEntity.isBaby() && !(livingEntity instanceof Villager)) {
            poseStack.translate(0.0, 0.03125, 0.0);
            poseStack.scale(0.7f, 0.7f, 0.7f);
            poseStack.translate(0.0, 1.0, 0.0);
        }
        this.getChestRenderer().translateAndRotate(poseStack);
        poseStack.translate(0.0, -0.25, 0.0);
        poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI));
        poseStack.scale(0.625f, -0.625f, -0.625f);
        if (livingEntity instanceof Villager || livingEntity instanceof ZombieVillager) {
            poseStack.translate(0.0, 0.1875, 0.0);
        }
        Minecraft.getInstance().gameRenderer.itemInHandRenderer.renderItem(livingEntity, wearItem, ItemDisplayContext.HEAD, false, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }
}

