/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class GlassMeterRenderer
extends BlockEntityWithoutLevelRenderer {
    public static void addVertex(VertexConsumer vertexBuilder, PoseStack poseStack, ColorARGB color, float x, float y, float u, float v) {
        vertexBuilder.addVertex(poseStack.last().pose(), x, y, 0.0f).setColor(color.getRed().value, color.getGreen().value, color.getBlue().value, color.getAlpha().value).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
    }

    public GlassMeterRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack matrixStack, MultiBufferSource renderBuffer, int combinedLight, int combinedOverlay) {
        this.renderModel(itemStack, matrixStack, renderBuffer, combinedLight, combinedOverlay);
        this.renderIndicators(itemStack, matrixStack, renderBuffer);
    }

    protected RenderType getRenderType() {
        return RenderType.entityTranslucent((ResourceLocation)GameRendering.EMPTY_TEXTURE);
    }

    protected ItemRenderer getItemRenderer() {
        return Minecraft.getInstance().getItemRenderer();
    }

    protected abstract void renderIndicators(ItemStack var1, PoseStack var2, MultiBufferSource var3);

    protected void renderModel(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        RenderType rendertype = ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true);
        BakedModel model = this.getItemRenderer().getModel(stack, null, null, 0);
        VertexConsumer builder = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.hasFoil());
        RandomSource random = RandomSource.create();
        for (Direction direction : (Direction[])ArrayUtils.add((Object[])Direction.values(), null)) {
            random.setSeed(42L);
            this.getItemRenderer().renderQuadList(matrix, builder, model.getQuads(null, direction, random, ModelData.EMPTY, rendertype), stack, combinedLight, combinedOverlay);
        }
    }
}

